/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.modelchecker;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Element;
import org.graphwalker.modelchecker.ContextChecker;

public class ContextsChecker {
    public static List<String> hasIssues(List<Context> contexts) {
        ArrayList<String> issues = new ArrayList<String>();
        for (Context context : contexts) {
            issues.addAll(ContextChecker.hasIssues(context));
        }
        HashSet<String> ids = new HashSet<String>();
        for (Context context : contexts) {
            if (ids.add(context.getModel().getId())) continue;
            issues.add("Id of the model is not unique: " + context.getModel().getId());
        }
        HashSet<Element> hashSet = new HashSet<Element>();
        for (Context context : contexts) {
            if (!hashSet.add(context.getModel())) {
                issues.add("Internal id of the model is not unique: " + context);
            }
            for (Element element : context.getModel().getElements()) {
                if (hashSet.add(element)) continue;
                issues.add("Internal id of the element is not unique: " + element);
            }
        }
        return issues;
    }
}

