/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.modelchecker;

import com.google.common.base.CharMatcher;
import java.util.ArrayList;
import java.util.List;
import org.graphwalker.core.model.Edge;
import org.graphwalker.modelchecker.ElementChecker;

public class EdgeChecker {
    private EdgeChecker() {
    }

    public static List<String> hasIssues(Edge.RuntimeEdge edge) {
        ArrayList<String> issues = new ArrayList<String>(ElementChecker.hasIssues(edge));
        if (edge.getTargetVertex() == null) {
            issues.add("Edge must have a target vertex.");
        }
        if (edge.hasName() && CharMatcher.whitespace().matchesAnyOf(edge.getName())) {
            issues.add("Name of edge cannot have any white spaces.");
        }
        if (edge.getWeight() < 0.0 || edge.getWeight() > 1.0) {
            issues.add("The weight must be a value between 0 and 1.");
        }
        return issues;
    }
}

