/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.modelchecker;

import java.util.ArrayList;
import java.util.List;
import org.graphwalker.core.model.Action;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Requirement;

public class ElementChecker {
    private ElementChecker() {
    }

    public static List<String> hasIssues(Element element) {
        ArrayList<String> issues = new ArrayList<String>();
        if (element.getId() == null) {
            issues.add("Id cannot be null");
        }
        if (element.hasRequirements()) {
            for (Requirement requirement : element.getRequirements()) {
                if (!requirement.getKey().isEmpty()) continue;
                issues.add("Requirement cannot be an empty string");
            }
        }
        if (element.hasActions()) {
            for (Action action : element.getActions()) {
                if (!action.getScript().isEmpty()) continue;
                issues.add("Script statement cannot be an empty string");
            }
        }
        return issues;
    }
}

