/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.modelchecker;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.graphwalker.core.model.Edge;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.Model;
import org.graphwalker.core.model.Vertex;
import org.graphwalker.modelchecker.EdgeChecker;
import org.graphwalker.modelchecker.ElementChecker;
import org.graphwalker.modelchecker.VertexChecker;

public class ModelChecker {
    private ModelChecker() {
    }

    public static List<String> hasIssues(Model.RuntimeModel model) {
        ArrayList<String> issues = new ArrayList<String>(ElementChecker.hasIssues(model));
        for (Vertex.RuntimeVertex vertex : model.getVertices()) {
            issues.addAll(VertexChecker.hasIssues(vertex));
        }
        for (Edge.RuntimeEdge edge : model.getEdges()) {
            issues.addAll(EdgeChecker.hasIssues(edge));
        }
        HashSet<String> ids = new HashSet<String>();
        for (Element element : model.getElements()) {
            if (ids.add(element.getId())) continue;
            if (element instanceof Edge.RuntimeEdge) {
                issues.add("Id of the edge is not unique: " + element.getId());
                continue;
            }
            issues.add("Id of the vertex is not unique: " + element.getId());
        }
        for (Edge.RuntimeEdge edge : model.getEdges()) {
            if (edge.hasName() || null == edge.getSourceVertex() || null == edge.getTargetVertex() || !edge.getSourceVertex().equals(edge.getTargetVertex())) continue;
            issues.add("Vertex: " + edge.getSourceVertex() + ", have a unnamed self loop edge.");
        }
        return issues;
    }
}

