/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.modelchecker;

import com.google.common.base.CharMatcher;
import java.util.ArrayList;
import java.util.List;
import org.graphwalker.core.model.Vertex;
import org.graphwalker.modelchecker.ElementChecker;

public class VertexChecker {
    private VertexChecker() {
    }

    public static List<String> hasIssues(Vertex.RuntimeVertex vertex) {
        ArrayList<String> issues = new ArrayList<String>(ElementChecker.hasIssues(vertex));
        if (vertex.getName() == null) {
            issues.add("Name of vertex cannot be null");
        } else {
            if (vertex.getName().isEmpty()) {
                issues.add("Name of vertex cannot be an empty string");
            }
            if (CharMatcher.whitespace().matchesAnyOf(vertex.getName())) {
                issues.add("Name of vertex cannot have any white spaces.");
            }
        }
        return issues;
    }
}

