/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.restful;

import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.graalvm.polyglot.Value;
import org.graphwalker.core.common.Objects;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.machine.ExecutionStatus;
import org.graphwalker.core.machine.FailFastStrategy;
import org.graphwalker.core.machine.Machine;
import org.graphwalker.core.machine.MachineException;
import org.graphwalker.core.machine.SimpleMachine;
import org.graphwalker.core.model.Action;
import org.graphwalker.core.statistics.Execution;
import org.graphwalker.io.factory.json.JsonContextFactory;
import org.graphwalker.java.test.Result;
import org.graphwalker.restful.Util;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="graphwalker")
public class Restful {
    private static final Logger logger = LoggerFactory.getLogger(Restful.class);
    private List<Context> contexts;
    private Machine machine;
    private Boolean verbose;
    private Boolean unvisited;
    private Boolean blocked;

    public Restful(List<Context> contexts, Boolean verbose, Boolean unvisited, Boolean blocked) throws Exception {
        this.verbose = verbose;
        this.unvisited = unvisited;
        this.blocked = blocked;
        if (contexts == null || contexts.isEmpty()) {
            return;
        }
        this.setContexts(contexts);
    }

    public void setContexts(List<Context> contexts) {
        if (this.blocked.booleanValue()) {
            org.graphwalker.io.common.Util.filterBlockedElements(contexts);
        }
        this.contexts = contexts;
        this.machine = new SimpleMachine(this.contexts);
    }

    @POST
    @Consumes(value={"text/plain;charset=UTF-8"})
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="load")
    public String load(String jsonGW3) {
        logger.debug("Received load with gw3: " + jsonGW3);
        JSONObject resultJson = new JSONObject();
        try {
            List<Context> contexts = new JsonContextFactory().create(jsonGW3);
            this.setContexts(contexts);
            resultJson.put("result", "ok");
        }
        catch (Exception e) {
            resultJson.put("result", "nok");
            resultJson.put("error", e.getMessage());
        }
        return resultJson.toString();
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="hasNext")
    public String hasNext() {
        logger.debug("Received hasNext");
        JSONObject resultJson = new JSONObject();
        try {
            if (this.machine.hasNextStep()) {
                resultJson.put("hasNext", "true").toString();
            } else {
                resultJson.put("hasNext", "false").toString();
            }
            resultJson.put("result", "ok");
        }
        catch (Exception e) {
            resultJson.put("result", "nok");
            resultJson.put("error", e.getMessage());
        }
        return resultJson.toString();
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="getNext")
    public String getNext() {
        JSONObject resultJson;
        logger.debug("Received getNext");
        try {
            this.machine.getNextStep();
            resultJson = Util.getStepAsJSON(this.machine, this.verbose, this.unvisited);
            resultJson.put("result", "ok");
        }
        catch (Exception e) {
            resultJson = new JSONObject();
            resultJson.put("result", "nok");
            resultJson.put("error", e.getMessage());
        }
        return resultJson.toString();
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Consumes(value={"text/plain;charset=UTF-8"})
    @Path(value="getData")
    public String getData() {
        logger.debug("Received getData");
        JSONObject resultJson = new JSONObject();
        try {
            Value bindings = this.machine.getCurrentContext().getExecutionEnvironment().getBindings("js");
            JSONObject data = new JSONObject();
            for (String key : bindings.getMemberKeys()) {
                data.put(key, bindings.getMember(key));
            }
            resultJson.put("data", data);
            resultJson.put("result", "ok");
        }
        catch (Exception e) {
            resultJson.put("result", "nok");
            resultJson.put("error", e.getMessage());
        }
        return resultJson.toString();
    }

    @PUT
    @Consumes(value={"text/plain;charset=UTF-8"})
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="setData/{script}")
    public String setData(@PathParam(value="script") String script) {
        logger.debug("Received setData with script: " + script);
        JSONObject resultJson = new JSONObject();
        try {
            this.machine.getCurrentContext().execute(new Action(script));
            resultJson.put("result", "ok");
        }
        catch (Exception e) {
            resultJson.put("result", "nok");
            resultJson.put("error", e.getMessage());
        }
        return resultJson.toString();
    }

    @PUT
    @Path(value="restart")
    @Produces(value={"text/plain;charset=UTF-8"})
    public String restart() {
        logger.debug("Received restart");
        JSONObject resultJson = new JSONObject();
        try {
            if (Objects.isNull(this.machine)) {
                throw new RuntimeException("No model(s) are loaded.");
            }
            if (this.machine.getProfiler().getExecutionPath().size() > 0) {
                Execution execution = this.machine.getProfiler().getExecutionPath().get(0);
                this.contexts = this.contexts.stream().peek(context -> {
                    if (execution.getContext().equals(context)) {
                        context.setNextElement(execution.getElement());
                    }
                    context.setExecutionStatus(ExecutionStatus.NOT_EXECUTED);
                }).collect(Collectors.toList());
                this.machine = new SimpleMachine(this.contexts);
            }
            resultJson.put("result", "ok");
        }
        catch (Exception e) {
            resultJson.put("result", "nok");
            resultJson.put("error", e.getMessage());
        }
        return resultJson.toString();
    }

    @PUT
    @Consumes(value={"text/plain;charset=UTF-8"})
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="fail/{reason}")
    public String fail(@PathParam(value="reason") String reason) {
        logger.debug("Received fail with reason: " + reason);
        JSONObject resultJson = new JSONObject();
        try {
            FailFastStrategy failFastStrategy = new FailFastStrategy();
            failFastStrategy.handle(this.machine, new MachineException(this.machine.getCurrentContext(), new Throwable(reason)));
            resultJson.put("result", "ok");
        }
        catch (Exception e) {
            resultJson.put("result", "nok");
            resultJson.put("error", e.getMessage());
        }
        return resultJson.toString();
    }

    @GET
    @Produces(value={"text/plain;charset=UTF-8"})
    @Path(value="getStatistics")
    public String getStatistics() {
        logger.debug("Received getStatistics");
        JSONObject resultJson = new JSONObject();
        try {
            Result result = new Result();
            result.updateResults(this.machine, null);
            resultJson = result.getResults();
            resultJson.put("result", "ok");
        }
        catch (Exception e) {
            resultJson.put("result", "nok");
            resultJson.put("error", e.getMessage());
        }
        return resultJson.toString();
    }

    public List<Context> getContexts() {
        return this.contexts;
    }

    public Machine getMachine() {
        return this.machine;
    }

    public Boolean getVerbose() {
        return this.verbose;
    }

    public Boolean getUnvisited() {
        return this.unvisited;
    }
}

