/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.restful;

import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.graalvm.polyglot.Value;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.machine.Machine;
import org.graphwalker.core.model.Action;
import org.graphwalker.core.model.Element;
import org.graphwalker.core.model.RuntimeBase;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class Util {
    public static JSONObject getStepAsJSON(Machine machine, boolean verbose, boolean showUnvisited) {
        JSONObject object = new JSONObject();
        if (verbose) {
            object.put("modelName", FilenameUtils.getBaseName(machine.getCurrentContext().getModel().getName()));
        }
        if (machine.getCurrentContext().getCurrentElement().hasName()) {
            object.put("currentElementName", machine.getCurrentContext().getCurrentElement().getName());
        } else {
            object.put("currentElementName", "");
        }
        if (verbose) {
            object.put("currentElementID", machine.getCurrentContext().getCurrentElement().getId());
            Value bindings = machine.getCurrentContext().getExecutionEnvironment().getBindings("js");
            JSONArray jsonKeys = new JSONArray();
            for (String key : bindings.getMemberKeys()) {
                JSONObject jsonKey = new JSONObject();
                jsonKey.put(key, bindings.getMember(key));
                jsonKeys.put(jsonKey);
            }
            object.put("data", jsonKeys);
            JSONArray jsonProperties = new JSONArray();
            RuntimeBase runtimeBase = (RuntimeBase)machine.getCurrentContext().getCurrentElement();
            for (Map.Entry entry : runtimeBase.getProperties().entrySet()) {
                JSONObject jsonKey = new JSONObject();
                jsonKey.put((String)entry.getKey(), entry.getValue());
                jsonProperties.put(jsonKey);
            }
            object.put("properties", jsonProperties);
            JSONArray jsonActions = new JSONArray();
            if (runtimeBase.hasActions()) {
                for (Action action : runtimeBase.getActions()) {
                    JSONObject jsonAction = new JSONObject();
                    jsonAction.put("Action", action.getScript());
                    jsonActions.put(jsonAction);
                }
                object.put("actions", jsonActions);
            }
        }
        if (showUnvisited) {
            Context context = machine.getCurrentContext();
            object.put("numberOfElements", context.getModel().getElements().size());
            object.put("numberOfUnvisitedElements", context.getProfiler().getUnvisitedElements(context).size());
            JSONArray jsonElements = new JSONArray();
            for (Element element : context.getProfiler().getUnvisitedElements(context)) {
                JSONObject jsonElement = new JSONObject();
                jsonElement.put("elementName", element.getName());
                if (verbose) {
                    jsonElement.put("elementId", element.getId());
                }
                jsonElements.put(jsonElement);
            }
            object.put("unvisitedElements", jsonElements);
        }
        return object;
    }
}

