/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.source;

import japa.parser.ASTHelper;
import japa.parser.JavaParser;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.ImportDeclaration;
import japa.parser.ast.PackageDeclaration;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.comments.Comment;
import japa.parser.ast.comments.LineComment;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.MemberValuePair;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.NormalAnnotationExpr;
import japa.parser.ast.expr.StringLiteralExpr;
import japa.parser.ast.type.Type;
import japa.parser.ast.visitor.VoidVisitorAdapter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Model;
import org.graphwalker.io.factory.ContextFactory;
import org.graphwalker.io.factory.ContextFactoryScanner;
import org.graphwalker.java.source.ChangeContext;
import org.graphwalker.java.source.CodeGeneratorException;
import org.graphwalker.java.source.SourceFile;
import org.graphwalker.java.source.cache.CacheEntry;
import org.graphwalker.java.source.cache.SimpleCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodeGenerator
extends VoidVisitorAdapter<ChangeContext> {
    private static final Logger logger = LoggerFactory.getLogger(CodeGenerator.class);
    private static CodeGenerator generator = new CodeGenerator();

    public static void generate(final Path input, final Path output) {
        final SimpleCache cache = new SimpleCache(output);
        try {
            Files.walkFileTree(input, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                    if (!cache.contains(file) || this.isModified(file)) {
                        try {
                            ContextFactory factory = ContextFactoryScanner.get((Path)file);
                            List contexts = factory.create(file);
                            logger.info("Source generated from: " + file.toString() + " -> ");
                            for (Context context : contexts) {
                                SourceFile sourceFile = new SourceFile(context.getModel().getName(), file, input, output);
                                CodeGenerator.write(context, sourceFile);
                                cache.add(file, new CacheEntry(file.toFile().lastModified(), true));
                                logger.info("                       " + sourceFile.getOutputPath());
                            }
                        }
                        catch (Throwable t) {
                            logger.info(t.getMessage());
                            cache.add(file, new CacheEntry(file.toFile().lastModified(), false));
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                private boolean isModified(Path file) throws IOException {
                    return !Files.getLastModifiedTime(file, new LinkOption[0]).equals(cache.get(file).getLastModifiedTime());
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    cache.add(file, new CacheEntry(file.toFile().lastModified(), false));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new CodeGeneratorException(e);
        }
    }

    private static void write(Context context, SourceFile file) throws IOException {
        try {
            Model.RuntimeModel model = context.getModel();
            String source = generator.generate(file, model);
            Files.createDirectories(file.getOutputPath().getParent(), new FileAttribute[0]);
            Files.write(file.getOutputPath(), source.getBytes(Charset.forName("UTF-8")), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Throwable t) {
            logger.error(t.getMessage());
            throw new CodeGeneratorException(t);
        }
    }

    public List<String> generate(String file) throws IOException {
        return this.generate(Paths.get(file, new String[0]));
    }

    public List<String> generate(File file) throws IOException {
        return this.generate(file.toPath());
    }

    public List<String> generate(Path path) throws IOException {
        ContextFactory factory = ContextFactoryScanner.get((Path)path);
        List contexts = factory.create(path);
        ArrayList<String> sources = new ArrayList<String>();
        for (Context context : contexts) {
            String sourceStr = "";
            SourceFile sourceFile = new SourceFile(context.getModel().getName(), path);
            sourceStr = sourceStr + this.generate(sourceFile, context.getModel());
            sources.add(sourceStr);
        }
        return sources;
    }

    public String generate(SourceFile sourceFile, Model.RuntimeModel model) {
        CompilationUnit compilationUnit = this.getCompilationUnit(sourceFile);
        ChangeContext changeContext = new ChangeContext(model);
        this.visit(compilationUnit, changeContext);
        this.removeMethods(compilationUnit, changeContext);
        this.generateMethods(compilationUnit, changeContext);
        return compilationUnit.toString();
    }

    private CompilationUnit getCompilationUnit(SourceFile sourceFile) {
        CompilationUnit compilationUnit;
        if (Files.exists(sourceFile.getOutputPath(), new LinkOption[0])) {
            try {
                compilationUnit = JavaParser.parse((File)sourceFile.getOutputPath().toFile());
            }
            catch (Throwable t) {
                logger.error(t.getMessage());
                throw new RuntimeException(t);
            }
        } else {
            compilationUnit = new CompilationUnit();
            compilationUnit.setComment((Comment)new LineComment(" Generated by GraphWalker (http://www.graphwalker.org)"));
            if (!"".equals(sourceFile.getPackageName())) {
                compilationUnit.setPackage(this.createPackageDeclaration(sourceFile));
            }
            compilationUnit.setImports(Arrays.asList(new ImportDeclaration(new NameExpr("org.graphwalker.java.annotation.Model"), false, false), new ImportDeclaration(new NameExpr("org.graphwalker.java.annotation.Vertex"), false, false), new ImportDeclaration(new NameExpr("org.graphwalker.java.annotation.Edge"), false, false)));
            ASTHelper.addTypeDeclaration((CompilationUnit)compilationUnit, (TypeDeclaration)this.getInterfaceName(sourceFile));
        }
        return compilationUnit;
    }

    private void removeMethods(CompilationUnit compilationUnit, ChangeContext changeContext) {
        if (0 < changeContext.getMethodDeclarations().size()) {
            ClassOrInterfaceDeclaration body = (ClassOrInterfaceDeclaration)compilationUnit.getTypes().get(0);
            body.getMembers().removeAll(changeContext.getMethodDeclarations());
        }
    }

    private void generateMethods(CompilationUnit compilationUnit, ChangeContext changeContext) {
        ClassOrInterfaceDeclaration body = (ClassOrInterfaceDeclaration)compilationUnit.getTypes().get(0);
        for (String methodName : changeContext.getMethodNames()) {
            ArrayList memberValuePairs;
            if (!this.isValidName(methodName)) continue;
            MethodDeclaration method = new MethodDeclaration(512, (Type)ASTHelper.VOID_TYPE, methodName);
            ArrayList<NormalAnnotationExpr> annotations = new ArrayList<NormalAnnotationExpr>();
            if (changeContext.isVertex(methodName)) {
                memberValuePairs = new ArrayList();
                annotations.add(new NormalAnnotationExpr(ASTHelper.createNameExpr((String)"Vertex"), memberValuePairs));
            } else {
                memberValuePairs = new ArrayList();
                annotations.add(new NormalAnnotationExpr(ASTHelper.createNameExpr((String)"Edge"), memberValuePairs));
            }
            method.setAnnotations(annotations);
            ASTHelper.addMember((TypeDeclaration)body, (BodyDeclaration)method);
        }
    }

    private boolean isValidName(String name) {
        if (null == name || name.isEmpty()) {
            return false;
        }
        boolean valid = true;
        for (int i = 0; i < name.length(); ++i) {
            if (0 == i) {
                valid &= Character.isJavaIdentifierStart(name.charAt(i));
                continue;
            }
            valid &= Character.isJavaIdentifierPart(name.charAt(i));
        }
        return valid;
    }

    public void visit(MethodDeclaration methodDeclaration, ChangeContext changeContext) {
        if (changeContext.getMethodNames().contains(methodDeclaration.getName())) {
            changeContext.getMethodNames().remove(methodDeclaration.getName());
        } else {
            changeContext.addMethodDeclaration(methodDeclaration);
        }
    }

    private PackageDeclaration createPackageDeclaration(SourceFile sourceFile) {
        return new PackageDeclaration(ASTHelper.createNameExpr((String)sourceFile.getPackageName()));
    }

    private ClassOrInterfaceDeclaration getInterfaceName(SourceFile sourceFile) {
        ClassOrInterfaceDeclaration classOrInterfaceDeclaration = new ClassOrInterfaceDeclaration(1, false, sourceFile.getClassName());
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        memberValuePairs.add(new MemberValuePair("file", (Expression)new StringLiteralExpr(sourceFile.getRelativePath().toString().replace(File.separator, "/"))));
        ArrayList<NormalAnnotationExpr> annotations = new ArrayList<NormalAnnotationExpr>();
        annotations.add(new NormalAnnotationExpr(ASTHelper.createNameExpr((String)"Model"), memberValuePairs));
        classOrInterfaceDeclaration.setAnnotations(annotations);
        classOrInterfaceDeclaration.setInterface(true);
        return classOrInterfaceDeclaration;
    }
}

