/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.source;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;

public final class SourceFile {
    private static final Path DEFAULT_PATH = Paths.get("/", new String[0]);
    private final Path inputPath;
    private final Path relativePath;
    private final Path outputPath;
    private final String packageName;
    private final String className;

    public SourceFile(String modelName, Path path) {
        this(modelName, path, DEFAULT_PATH, DEFAULT_PATH);
    }

    public SourceFile(Path inputPath, Path basePath, Path outputPath) {
        this(SourceFile.getModelName(inputPath), inputPath, basePath, outputPath);
    }

    public SourceFile(String modelName, Path inputPath, Path basePath, Path outputPath) {
        this.className = modelName;
        this.inputPath = inputPath;
        this.relativePath = basePath.relativize(inputPath);
        this.packageName = null != this.relativePath.getParent() ? this.relativePath.getParent().toString().replace(File.separator, ".").replaceAll(" ", "_") : "";
        this.outputPath = outputPath.resolve(this.relativePath).resolveSibling(this.className + ".java");
    }

    public Path getInputPath() {
        return this.inputPath;
    }

    public Path getRelativePath() {
        return this.relativePath;
    }

    public Path getOutputPath() {
        return this.outputPath;
    }

    public String getPackageName() {
        return this.packageName;
    }

    private static String getModelName(Path inputPath) {
        return SourceFile.removeExtension(inputPath.getFileName().toString());
    }

    private static String removeExtension(String filename) {
        String ext = FilenameUtils.getExtension((String)filename);
        if ("".equals(ext)) {
            return filename;
        }
        int index = filename.lastIndexOf(ext) - 1;
        return filename.substring(0, index);
    }

    public String getClassName() {
        return this.className;
    }
}

