/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.StringUtils;
import org.graphwalker.java.test.Configuration;
import org.graphwalker.java.test.ContextConfiguration;
import org.graphwalker.java.test.IsolatedClassLoader;
import org.graphwalker.java.test.Reflector;
import org.graphwalker.java.test.Result;
import org.graphwalker.maven.plugin.DefaultMojoBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.TEST_COMPILE, lifecycle="graphwalker")
public final class TestMojo
extends DefaultMojoBase {
    private static final Logger logger = LoggerFactory.getLogger(TestMojo.class);
    @Parameter(property="project.testClasspathElements")
    private List<String> classpathElements;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    private File testClassesDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter(defaultValue="${project.build.directory}/graphwalker-reports")
    private File reportsDirectory;
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean mavenTestSkip;
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(property="graphwalker.test.skip", defaultValue="false")
    private boolean graphwalkerTestSkip;
    @Parameter(property="graphwalker.includes")
    private Set<String> includes;
    @Parameter(property="graphwalker.excludes")
    private Set<String> excludes;
    @Parameter(property="graphwalker.test", defaultValue="*")
    private String test;
    @Parameter(property="graphwalker.groups", defaultValue="*")
    private String groups;

    protected List<String> getClasspathElements() {
        return this.classpathElements;
    }

    protected File getTestClassesDirectory() {
        return this.testClassesDirectory;
    }

    protected File getClassesDirectory() {
        return this.classesDirectory;
    }

    protected File getReportsDirectory() {
        return this.reportsDirectory;
    }

    protected boolean getSkipTests() {
        return this.mavenTestSkip || this.graphwalkerTestSkip || this.skipTests;
    }

    protected Collection<String> getIncludes() {
        return this.includes;
    }

    protected Collection<String> getExcludes() {
        return this.excludes;
    }

    protected String getTest() {
        if (System.getProperties().containsKey("test")) {
            return System.getProperty("test");
        }
        return this.test;
    }

    protected String getGroups() {
        if (System.getProperties().containsKey("groups")) {
            return System.getProperty("groups");
        }
        return this.groups;
    }

    protected Properties createProperties() {
        Properties properties = (Properties)System.getProperties().clone();
        properties.putAll((Map<?, ?>)((Properties)this.getMavenProject().getProperties().clone()));
        properties.put("groups", this.groups);
        properties.put("test", this.test);
        properties.putAll((Map<?, ?>)((Properties)this.getSession().getUserProperties().clone()));
        return properties;
    }

    protected Properties switchProperties(Properties properties) {
        Properties oldProperties = (Properties)System.getProperties().clone();
        System.setProperties(properties);
        return oldProperties;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.getSkipTests()) {
            this.displayHeader();
            IsolatedClassLoader classLoader = new IsolatedClassLoader(this.classpathElements);
            Properties properties = this.switchProperties(this.createProperties());
            Configuration configuration = this.createConfiguration();
            Reflector reflector = new Reflector(configuration, (ClassLoader)classLoader);
            this.displayConfiguration(configuration, reflector);
            Result result = reflector.execute();
            this.displayResult(result);
            reflector.reportResults(this.getReportsDirectory(), this.getSession().getStartTime(), this.getSession().getSystemProperties());
            this.switchProperties(properties);
        }
    }

    private void displayHeader() {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
            this.getLog().info((CharSequence)"  _____             _   _ _ _     _ _                                   ");
            this.getLog().info((CharSequence)" |   __|___ ___ ___| |_| | | |___| | |_ ___ ___                         ");
            this.getLog().info((CharSequence)" |  |  |  _| .'| . |   | | | | .'| | '_| -_|  _|                        ");
            this.getLog().info((CharSequence)" |_____|_| |__,|  _|_|_|_____|__,|_|_,_|___|_|                          ");
            this.getLog().info((CharSequence)("               |_|         (" + this.getVersion() + ")                            "));
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVersion() {
        Properties properties = new Properties();
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/version.properties");
        if (null != inputStream) {
            try {
                properties.load(inputStream);
            }
            catch (IOException e) {
                logger.error(e.getMessage());
                String string = "unknown";
                return string;
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        return properties.getProperty("graphwalker.version");
    }

    private Configuration createConfiguration() {
        Configuration configuration = new Configuration();
        if (StringUtils.isBlank((String)this.getTest())) {
            configuration.setIncludes(this.getIncludes());
            configuration.setExcludes(this.getExcludes());
        } else {
            for (String test : this.getTest().split(",")) {
                if (!StringUtils.isNotBlank((String)(test = test.trim()))) continue;
                if (test.startsWith("!")) {
                    if (!StringUtils.isNotBlank((String)(test = test.substring(1)))) continue;
                    configuration.addExclude(test);
                    continue;
                }
                configuration.addInclude(test);
            }
        }
        for (String group : this.getGroups().split(",")) {
            configuration.addGroup(group.trim());
        }
        return configuration;
    }

    private void displayConfiguration(Configuration configuration, Reflector reflector) {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"Configuration:");
            this.getLog().info((CharSequence)("    Include = " + configuration.getIncludes()));
            this.getLog().info((CharSequence)("    Exclude = " + configuration.getExcludes()));
            this.getLog().info((CharSequence)("     Groups = " + configuration.getGroups()));
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"Tests:");
            if (null == reflector.getMachineConfiguration() || reflector.getMachineConfiguration().getContextConfigurations().isEmpty()) {
                this.getLog().info((CharSequence)"  No tests found");
            } else {
                for (ContextConfiguration context : reflector.getMachineConfiguration().getContextConfigurations()) {
                    this.getLog().info((CharSequence)("    " + context.getTestClassName() + "(" + context.getPathGeneratorName() + ", " + context.getStopConditionName() + ", " + context.getStopConditionValue() + ")"));
                }
                this.getLog().info((CharSequence)"");
            }
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        }
    }

    private void displayResult(Result result) {
        if (this.getLog().isErrorEnabled() && result.hasErrors()) {
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
            for (String error : result.getErrors()) {
                this.getLog().error((CharSequence)error);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"Result :");
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)result.getResultsAsString());
            this.getLog().info((CharSequence)"");
        }
    }
}

