/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.maven.plugin;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.graphwalker.core.machine.Context;
import org.graphwalker.core.model.Model;
import org.graphwalker.io.factory.ContextFactory;
import org.graphwalker.io.factory.ContextFactoryScanner;
import org.graphwalker.java.source.CodeGenerator;
import org.graphwalker.java.source.SourceFile;

@Mojo(name="watch")
public final class WatchMojo
extends AbstractMojo {
    private static final WatchEvent.Kind[] EVENT_TYPES = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    @Component
    private MavenProject mavenProject;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/graphwalker")
    private File sourcesDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/graphwalker")
    private File testSourcesDirectory;
    private WatchService watchService;
    private final CodeGenerator codeGenerator = new CodeGenerator();
    private final Map<Path, File> resourceMap = new HashMap<Path, File>();
    private final Map<WatchKey, Path> watchKeyMap = new HashMap<WatchKey, Path>();

    private static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    private String getEncoding() {
        return StringUtils.isEmpty((String)this.encoding) ? ReaderFactory.FILE_ENCODING : this.encoding;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.addResources(this.mavenProject.getResources(), this.sourcesDirectory);
            this.addResources(this.mavenProject.getTestResources(), this.testSourcesDirectory);
            this.watch(this.resourceMap.keySet());
            while (true) {
                WatchKey watchKey;
                Path path;
                if (null == (path = this.watchKeyMap.get(watchKey = this.getWatchService().take()))) {
                    continue;
                }
                for (WatchEvent<?> event : watchKey.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    WatchEvent file = WatchMojo.cast(event);
                    Path resolvedPath = path.resolve((Path)file.context());
                    if (StandardWatchEventKinds.ENTRY_CREATE == event.kind() || StandardWatchEventKinds.ENTRY_MODIFY == event.kind()) {
                        this.update(this.getRootPath(resolvedPath), resolvedPath);
                        continue;
                    }
                    if (StandardWatchEventKinds.ENTRY_DELETE != event.kind()) continue;
                    this.delete(this.getRootPath(resolvedPath), resolvedPath);
                }
                watchKey.reset();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("", e);
        }
    }

    private void addResources(List<Resource> resources, File outputDirectory) {
        for (Resource resource : resources) {
            this.resourceMap.put(FileSystems.getDefault().getPath(resource.getDirectory(), new String[0]), outputDirectory);
        }
    }

    private WatchService getWatchService() throws IOException {
        if (null == this.watchService) {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        return this.watchService;
    }

    private void watch(Set<Path> paths) throws IOException {
        for (Path path : paths) {
            this.watch(path);
        }
    }

    private void watch(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0]) && !this.watchKeyMap.values().contains(path) && Files.isDirectory(path, new LinkOption[0])) {
            WatchKey watchKey = path.register(this.getWatchService(), EVENT_TYPES, SensitivityWatchEventModifier.HIGH);
            this.watchKeyMap.put(watchKey, path);
            this.getLog().info((CharSequence)("Watching: " + path.toString()));
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attributes) throws IOException {
                    WatchMojo.this.watch(path);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private Path getRootPath(Path path) throws MojoExecutionException {
        for (Path rootPath : this.resourceMap.keySet()) {
            if (!path.startsWith(rootPath)) continue;
            return rootPath;
        }
        throw new MojoExecutionException("Path not found");
    }

    private boolean isModified(Path outputPath, Path path) throws IOException {
        return Files.getLastModifiedTime(outputPath, new LinkOption[0]).to(TimeUnit.MILLISECONDS) < Files.getLastModifiedTime(path, new LinkOption[0]).to(TimeUnit.MILLISECONDS);
    }

    private boolean isSupportedFileType(Path path) throws IOException {
        return null != ContextFactoryScanner.get((Path)path);
    }

    private void generate(SourceFile sourceFile) throws IOException {
        File outputFile = sourceFile.getOutputPath().toFile();
        ContextFactory contextFactory = ContextFactoryScanner.get((Path)sourceFile.getInputPath());
        List contexts = contextFactory.create(sourceFile.getInputPath());
        for (Context context : contexts) {
            try {
                String existingSource;
                Model.RuntimeModel model = context.getModel();
                String source = this.codeGenerator.generate(sourceFile, model);
                if (Files.exists(sourceFile.getOutputPath(), new LinkOption[0]) && (existingSource = StringUtils.removeDuplicateWhitespace((String)FileUtils.fileRead((File)outputFile, (String)this.getEncoding()))).equals(StringUtils.removeDuplicateWhitespace((String)new String(source.getBytes(), this.getEncoding())))) {
                    return;
                }
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)("Generate: " + sourceFile.getOutputPath()));
                }
                FileUtils.mkdir((String)sourceFile.getOutputPath().getParent().toFile().getAbsolutePath());
                FileUtils.fileDelete((String)outputFile.getAbsolutePath());
                FileUtils.fileWrite((String)outputFile.getAbsolutePath(), (String)this.getEncoding(), (String)source);
            }
            catch (Throwable t) {
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)("Error: Generate: " + sourceFile.getOutputPath()));
                }
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Error: Generate: " + sourceFile.getOutputPath()), t);
            }
        }
    }

    private void update(Path root, Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0]) && !Files.isHidden(path)) {
            SourceFile sourceFile;
            if (Files.isDirectory(path, new LinkOption[0])) {
                this.watch(path);
            } else if (this.isSupportedFileType(path) && (!Files.exists((sourceFile = new SourceFile(path, root, this.resourceMap.get(root).toPath())).getOutputPath(), new LinkOption[0]) || this.isModified(sourceFile.getOutputPath(), path))) {
                this.generate(sourceFile);
            }
        }
    }

    private void delete(Path root, Path path) throws IOException {
        SourceFile sourceFile;
        if (this.isSupportedFileType(path) && Files.exists((sourceFile = new SourceFile(path, root, this.resourceMap.get(root).toPath())).getOutputPath(), new LinkOption[0])) {
            Files.delete(sourceFile.getOutputPath());
            if (!Files.exists(sourceFile.getOutputPath(), new LinkOption[0])) {
                this.getLog().info((CharSequence)("Delete: " + sourceFile.getOutputPath()));
            }
        }
    }
}

