/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.collections;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.AbstractIntBidirectionalIterator;
import java.util.BitSet;
import java.util.NoSuchElementException;

public final class BitSetIterator
extends AbstractIntBidirectionalIterator {
    private final int firstBit;
    private final int lastBit;
    private int nextBit;
    private BitSet bitSet;

    public BitSetIterator(BitSet set) {
        this(set, 0);
    }

    public BitSetIterator(BitSet set, int start) {
        this(set, start, set.size());
    }

    public BitSetIterator(BitSet set, int start, int end) {
        this(set, start, end, start);
    }

    public BitSetIterator(BitSet set, int start, int end, int initial) {
        Preconditions.checkArgument((start >= 0 ? 1 : 0) != 0, (Object)"Starting index must be non-negative");
        Preconditions.checkArgument((start <= end ? 1 : 0) != 0, (Object)"Starting index must not be past ending index");
        Preconditions.checkArgument((initial >= start ? 1 : 0) != 0, (Object)"initial index must be >= start");
        Preconditions.checkArgument((initial <= end ? 1 : 0) != 0, (Object)"initial index must be <= end");
        this.bitSet = set;
        this.firstBit = start;
        this.lastBit = end;
        this.nextBit = this.bitSet.nextSetBit(initial);
        if (this.nextBit < 0) {
            this.nextBit = this.lastBit;
        }
    }

    public boolean hasNext() {
        return this.nextBit >= this.firstBit && this.nextBit < this.lastBit;
    }

    private int previousSetBit(int start) {
        for (int i = start; i >= this.firstBit; --i) {
            if (!this.bitSet.get(i)) continue;
            return i;
        }
        return -1;
    }

    public boolean hasPrevious() {
        return this.previousSetBit(this.nextBit - 1) >= this.firstBit;
    }

    public int nextInt() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int retval = this.nextBit;
        this.nextBit = this.bitSet.nextSetBit(this.nextBit + 1);
        if (this.nextBit < 0) {
            this.nextBit = this.lastBit;
        }
        return retval;
    }

    public int previousInt() {
        int prevBit = this.previousSetBit(this.nextBit - 1);
        if (prevBit < 0) {
            throw new NoSuchElementException();
        }
        this.nextBit = prevBit;
        return this.nextBit;
    }
}

