/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.collections;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.grouplens.lenskit.collections.FastCollection;
import org.grouplens.lenskit.collections.IntIntervalList;
import org.grouplens.lenskit.collections.LongUtils;
import org.grouplens.lenskit.collections.ObjectCollectionWrapper;
import org.grouplens.lenskit.collections.Pointer;
import org.grouplens.lenskit.collections.Pointers;
import org.grouplens.lenskit.collections.RepeatedList;

public final class CollectionUtils {
    private static final LoadingCache<Class<?>, Optional<Method>> fastIteratorMethods = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Optional<Method>>(){

        public Optional<Method> load(Class<?> key) {
            return Optional.fromNullable((Object)MethodUtils.getAccessibleMethod(key, (String)"fastIterator", (Class[])new Class[0]));
        }
    });

    private CollectionUtils() {
    }

    public static <E> Iterable<E> fast(final Iterable<E> iter) {
        if (iter instanceof FastCollection) {
            return new Iterable<E>(){

                @Override
                public Iterator<E> iterator() {
                    return ((FastCollection)iter).fastIterator();
                }
            };
        }
        Optional fastMethod = (Optional)fastIteratorMethods.getUnchecked(iter.getClass());
        if (fastMethod.isPresent()) {
            final Method method = (Method)fastMethod.get();
            return new Iterable<E>(){

                @Override
                public Iterator<E> iterator() {
                    try {
                        return (Iterator)method.invoke((Object)iter, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        return iter.iterator();
                    }
                    catch (InvocationTargetException e) {
                        throw Throwables.propagate((Throwable)e.getCause());
                    }
                }
            };
        }
        return iter;
    }

    @Deprecated
    public static LongCollection fastCollection(Collection<Long> longs) {
        return LongUtils.asLongCollection(longs);
    }

    @Deprecated
    public static LongSet fastSet(Set<Long> longs) {
        return LongUtils.asLongSet(longs);
    }

    public static <E> ObjectCollection<E> objectCollection(Collection<E> objects) {
        if (objects instanceof ObjectCollection) {
            return (ObjectCollection)objects;
        }
        return new ObjectCollectionWrapper<E>(objects);
    }

    public static <T> List<T> repeat(T obj, int n) {
        return new RepeatedList<T>(obj, n);
    }

    public static <E> FastCollection<E> emptyFastCollection() {
        return new EmptyFastCollection();
    }

    @Deprecated
    public static <E> Pointer<E> pointer(Iterator<E> iter) {
        return Pointers.fromIterator(iter);
    }

    public static IntList interval(int from, int to) {
        Preconditions.checkArgument((to >= from ? 1 : 0) != 0, (Object)"last integer less than first");
        return new IntIntervalList(from, to);
    }

    private static class EmptyFastCollection<E>
    extends AbstractCollection<E>
    implements FastCollection<E> {
        private EmptyFastCollection() {
        }

        @Override
        public Iterator<E> fastIterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }
    }
}

