/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.collections;

import it.unimi.dsi.fastutil.ints.AbstractIntList;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.Serializable;

public class IntIntervalList
extends AbstractIntList
implements Serializable {
    private static final long serialVersionUID = -914440213158448384L;
    private final int startIndex;
    private final int endIndex;

    @Deprecated
    public IntIntervalList(int size) {
        this(0, size);
    }

    private static void checkIndex(int idx, int start, int end) {
        if (idx < 0 || start + idx >= end) {
            throw new IndexOutOfBoundsException(String.format("%d not in [%d,%d)", idx, start, end));
        }
    }

    @Deprecated
    public IntIntervalList(int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("end < start");
        }
        this.startIndex = start;
        this.endIndex = end;
    }

    public int getInt(int index) {
        IntIntervalList.checkIndex(index, this.startIndex, this.endIndex);
        return this.startIndex + index;
    }

    public int size() {
        return this.endIndex - this.startIndex;
    }

    public IntListIterator listIterator(int idx) {
        IntIntervalList.checkIndex(idx, this.startIndex, this.endIndex + 1);
        return IntIterators.fromTo((int)(this.startIndex + idx), (int)this.endIndex);
    }
}

