/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.grouplens.lenskit.collections.Pointer;

class IteratorPointer<E>
implements Pointer<E> {
    private Iterator<E> iterator;
    private E element;
    private boolean atEnd;

    public IteratorPointer(Iterator<E> iter) {
        this.iterator = iter;
        if (iter.hasNext()) {
            this.element = iter.next();
            this.atEnd = false;
        } else {
            this.element = null;
            this.atEnd = true;
        }
    }

    @Override
    public boolean advance() {
        if (this.iterator.hasNext()) {
            this.element = this.iterator.next();
            return true;
        }
        this.element = null;
        this.atEnd = true;
        return false;
    }

    @Override
    public E get() {
        if (this.atEnd) {
            throw new NoSuchElementException();
        }
        return this.element;
    }

    @Override
    public boolean isAtEnd() {
        return this.atEnd;
    }
}

