/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.collections;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.longs.AbstractLongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.grouplens.lenskit.collections.BitSetIterator;
import org.grouplens.lenskit.collections.BitSetPointer;
import org.grouplens.lenskit.collections.IntPointer;
import org.grouplens.lenskit.collections.LongSortedArraySet;
import org.grouplens.lenskit.collections.MoreArrays;
import org.grouplens.lenskit.collections.Pointers;
import org.grouplens.lenskit.collections.RemovableLongSortedArraySet;

public final class LongKeyDomain
implements Serializable {
    private static final LongKeyDomain EMPTY_DOMAIN = LongKeyDomain.wrap(new long[0], 0, true);
    private static final long serialVersionUID = 1L;
    private final long[] keys;
    private final int domainSize;
    private final BitSet mask;
    private boolean unowned = false;

    public static LongKeyDomain wrap(long[] keys, int size, boolean initiallyActive) {
        Preconditions.checkArgument((size <= keys.length ? 1 : 0) != 0, (Object)"size too large");
        assert (MoreArrays.isSorted(keys, 0, size));
        BitSet mask = new BitSet(size);
        if (initiallyActive) {
            mask.set(0, size);
        }
        return new LongKeyDomain(keys, size, mask);
    }

    public static LongKeyDomain fromCollection(Collection<Long> keys, boolean initiallyActive) {
        if (keys instanceof LongSortedArraySet) {
            return ((LongSortedArraySet)((Object)keys)).getDomain().compactCopy(initiallyActive);
        }
        long[] keyArray = keys instanceof LongCollection ? ((LongCollection)keys).toLongArray() : LongIterators.unwrap((LongIterator)LongIterators.asLongIterator(keys.iterator()));
        Arrays.sort(keyArray);
        int size = MoreArrays.deduplicate(keyArray, 0, keyArray.length);
        return LongKeyDomain.wrap(keyArray, size, initiallyActive);
    }

    public static LongKeyDomain fromCollection(Collection<Long> keys) {
        return LongKeyDomain.fromCollection(keys, true);
    }

    public static LongKeyDomain create(long ... keys) {
        return LongKeyDomain.fromCollection((Collection<Long>)LongArrayList.wrap((long[])keys));
    }

    public static LongKeyDomain empty() {
        return EMPTY_DOMAIN;
    }

    private LongKeyDomain(long[] ks, int end, BitSet m) {
        this.keys = ks;
        this.domainSize = end;
        this.mask = m;
    }

    public int getIndex(long key) {
        return Arrays.binarySearch(this.keys, 0, this.domainSize, key);
    }

    public int getIndexIfActive(long key) {
        int idx = this.getIndex(key);
        if (idx >= 0 && !this.mask.get(idx)) {
            return -idx - 1;
        }
        return idx;
    }

    public int upperBound(long key) {
        int index = this.getIndex(key);
        if (index >= 0) {
            return index + 1;
        }
        return -index - 1;
    }

    public int lowerBound(long key) {
        int index = this.getIndex(key);
        if (index >= 0) {
            return index;
        }
        return -index - 1;
    }

    public LongKeyDomain clone() {
        if (this.unowned) {
            this.unowned = false;
            return this;
        }
        return new LongKeyDomain(this.keys, this.domainSize, (BitSet)this.mask.clone());
    }

    public LongKeyDomain unowned() {
        this.unowned = true;
        return this;
    }

    public void acquire() {
        this.unowned = false;
    }

    public LongKeyDomain inactiveCopy() {
        return new LongKeyDomain(this.keys, this.domainSize, new BitSet());
    }

    public LongKeyDomain compactCopy() {
        return this.compactCopy(true);
    }

    public LongKeyDomain compactCopy(boolean active) {
        long[] compactKeys;
        if (this.domainSize == this.keys.length && this.mask.nextClearBit(0) >= this.domainSize) {
            compactKeys = this.keys;
        } else if (this.mask.nextClearBit(0) >= this.domainSize) {
            int size = this.domainSize();
            compactKeys = new long[size];
            System.arraycopy(this.keys, 0, compactKeys, 0, size);
        } else {
            compactKeys = LongIterators.unwrap((LongIterator)this.keyIterator(this.activeIndexIterator(false)));
            assert (compactKeys.length == this.size());
        }
        BitSet compactMask = new BitSet(compactKeys.length);
        if (active) {
            compactMask.set(0, compactKeys.length, true);
        }
        return new LongKeyDomain(compactKeys, compactKeys.length, compactMask);
    }

    public boolean indexIsActive(int idx) {
        assert (idx >= 0 && idx < this.domainSize);
        return this.mask.get(idx);
    }

    public boolean keyIsActive(long key) {
        return this.getIndexIfActive(key) >= 0;
    }

    public boolean containsKey(long key) {
        return this.getIndex(key) >= 0;
    }

    public long getKey(int idx) {
        assert (idx >= 0 && idx < this.domainSize);
        return this.keys[idx];
    }

    public int domainSize() {
        return this.domainSize;
    }

    public int size() {
        return this.mask.cardinality();
    }

    public IntBidirectionalIterator activeIndexIterator(boolean mayBeModified) {
        if (this.mask.nextClearBit(0) < this.domainSize) {
            BitSet snap = this.mask;
            if (mayBeModified) {
                snap = (BitSet)snap.clone();
            }
            return new BitSetIterator(snap, 0, this.domainSize);
        }
        return IntIterators.fromTo((int)0, (int)this.domainSize);
    }

    public IntPointer activeIndexPointer(boolean mayBeModified) {
        if (this.mask.nextClearBit(0) < this.domainSize) {
            BitSet snap = this.mask;
            if (mayBeModified) {
                snap = (BitSet)snap.clone();
            }
            return new BitSetPointer(snap, 0, this.domainSize);
        }
        return Pointers.fromTo(0, this.domainSize);
    }

    public IntBidirectionalIterator activeIndexIterator(int min, int max, int idx) {
        assert (min >= 0);
        assert (max <= this.domainSize);
        assert (idx >= min && idx <= max);
        return new BitSetIterator(this.mask, min, max, idx);
    }

    public LongBidirectionalIterator keyIterator(IntBidirectionalIterator iter) {
        return new KeyIter(iter);
    }

    public LongSortedSet activeSetView() {
        return new LongSortedArraySet(this);
    }

    public LongSortedSet modifiableActiveSetView() {
        return new RemovableLongSortedArraySet(this);
    }

    public LongSortedSet domain() {
        BitSet bits = new BitSet(this.domainSize);
        bits.set(0, this.domainSize);
        return new LongSortedArraySet(new LongKeyDomain(this.keys, this.domainSize, bits));
    }

    public BitSet getActiveMask() {
        return this.mask;
    }

    public boolean isCompatibleWith(@Nonnull LongKeyDomain other) {
        return this.keys == other.keys;
    }

    public LongKeyDomain invert() {
        this.mask.flip(0, this.domainSize);
        return this;
    }

    public LongKeyDomain setAllActive(boolean active) {
        this.mask.set(0, this.domainSize, active);
        return this;
    }

    public LongKeyDomain setActive(int idx, boolean active) {
        Preconditions.checkElementIndex((int)idx, (int)this.domainSize);
        this.mask.set(idx, active);
        return this;
    }

    public LongKeyDomain setActive(BitSet active) {
        this.mask.set(0, this.domainSize);
        this.mask.and(active);
        return this;
    }

    private class KeyIter
    extends AbstractLongBidirectionalIterator {
        private final IntBidirectionalIterator delegate;

        public KeyIter(IntBidirectionalIterator iter) {
            this.delegate = iter;
        }

        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public long nextLong() {
            return LongKeyDomain.this.getKey(this.delegate.nextInt());
        }

        public long previousLong() {
            return LongKeyDomain.this.getKey(this.delegate.previousInt());
        }
    }
}

