/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.collections;

import it.unimi.dsi.fastutil.longs.AbstractLongSortedSet;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.grouplens.lenskit.collections.LongKeyDomain;

@Deprecated
public class LongSortedArraySet
extends AbstractLongSortedSet
implements Serializable {
    private static final long serialVersionUID = 2L;
    final LongKeyDomain keys;
    private final int minIndex;
    private final int maxIndex;

    LongSortedArraySet(@Nonnull LongKeyDomain ks) {
        this(ks, 0, ks.domainSize());
    }

    LongSortedArraySet(@Nonnull LongKeyDomain ks, int min, int max) {
        assert (min >= 0);
        assert (max >= min);
        this.keys = ks;
        this.keys.acquire();
        this.minIndex = min;
        this.maxIndex = max;
    }

    @Deprecated
    public LongSortedArraySet(@Nonnull Collection<Long> items) {
        this(LongKeyDomain.fromCollection(items));
    }

    @Deprecated
    public LongSortedArraySet(long[] items) {
        this(LongKeyDomain.create(items));
    }

    LongKeyDomain getDomain() {
        return this.keys;
    }

    public LongComparator comparator() {
        return null;
    }

    public long firstLong() {
        int idx = this.keys.getActiveMask().nextSetBit(this.minIndex);
        if (idx >= this.minIndex && idx < this.maxIndex) {
            return this.keys.getKey(idx);
        }
        throw new NoSuchElementException();
    }

    public long lastLong() {
        for (int idx = this.maxIndex - 1; idx >= this.minIndex; --idx) {
            if (!this.keys.indexIsActive(idx)) continue;
            return this.keys.getKey(idx);
        }
        throw new NoSuchElementException();
    }

    public LongBidirectionalIterator iterator(long key) {
        int index = Math.max(this.keys.upperBound(key), this.minIndex);
        return this.keys.keyIterator(this.keys.activeIndexIterator(this.minIndex, this.maxIndex, index));
    }

    public LongSortedSet subSet(long startKey, long endKey) {
        int start = this.keys.lowerBound(startKey);
        int end = this.keys.lowerBound(endKey);
        return new LongSortedArraySet(this.keys, start, end);
    }

    public LongSortedSet headSet(long key) {
        int start = this.minIndex;
        int end = this.keys.lowerBound(key);
        return new LongSortedArraySet(this.keys, start, end);
    }

    public LongSortedSet tailSet(long key) {
        int start = this.keys.lowerBound(key);
        int end = this.maxIndex;
        return new LongSortedArraySet(this.keys, start, end);
    }

    public LongBidirectionalIterator iterator() {
        return this.keys.keyIterator(this.keys.activeIndexIterator(this.minIndex, this.maxIndex, this.minIndex));
    }

    public int size() {
        if (this.minIndex == 0 && this.maxIndex == this.keys.domainSize()) {
            return this.keys.size();
        }
        BitSet bits = new BitSet(this.maxIndex);
        bits.set(this.minIndex, this.maxIndex);
        bits.and(this.keys.getActiveMask());
        return bits.cardinality();
    }

    public boolean contains(long key) {
        int idx = this.keys.getIndexIfActive(key);
        return idx >= this.minIndex && idx < this.maxIndex;
    }
}

