/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.collections;

import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Set;
import org.grouplens.lenskit.collections.LongKeyDomain;
import org.grouplens.lenskit.collections.LongSortedArraySet;

public final class LongUtils {
    private LongUtils() {
    }

    public static LongSortedSet packedSet(Collection<Long> longs) {
        return LongKeyDomain.fromCollection(longs, true).activeSetView();
    }

    public static LongSortedSet packedSet(long ... longs) {
        return LongKeyDomain.create(longs).activeSetView();
    }

    public static LongCollection asLongCollection(Collection<Long> longs) {
        if (longs instanceof LongCollection) {
            return (LongCollection)longs;
        }
        return new LongCollectionWrapper(longs);
    }

    public static LongSet asLongSet(Set<Long> longs) {
        if (longs == null) {
            return null;
        }
        if (longs instanceof LongSet) {
            return (LongSet)longs;
        }
        return new LongSetWrapper(longs);
    }

    public static LongSortedSet setDifference(LongSet items, LongSet exclude) {
        long[] data = new long[items.size()];
        LongIterator iter = items.iterator();
        int i = 0;
        while (iter.hasNext()) {
            long x = iter.nextLong();
            if (exclude.contains(x)) continue;
            data[i++] = x;
        }
        if (!(items instanceof LongSortedSet)) {
            Arrays.sort(data, 0, i);
        }
        if (data.length * 2 > i * 3) {
            data = Arrays.copyOf(data, i);
        }
        return new LongSortedArraySet(LongKeyDomain.wrap(data, i, true));
    }

    public static int unionSize(LongSortedSet a, LongSortedSet b) {
        LongKeyDomain db;
        LongKeyDomain da;
        if (a instanceof LongSortedArraySet && b instanceof LongSortedArraySet && (da = ((LongSortedArraySet)a).getDomain()).isCompatibleWith(db = ((LongSortedArraySet)b).getDomain())) {
            BitSet bits = (BitSet)da.getActiveMask().clone();
            bits.or(db.getActiveMask());
            return bits.cardinality();
        }
        LongBidirectionalIterator ait = a.iterator();
        LongBidirectionalIterator bit = b.iterator();
        boolean hasA = ait.hasNext();
        boolean hasB = bit.hasNext();
        long nextA = hasA ? ait.nextLong() : Long.MAX_VALUE;
        long nextB = hasB ? bit.nextLong() : Long.MAX_VALUE;
        int nshared = 0;
        while (hasA && hasB) {
            if (nextA < nextB) {
                hasA = ait.hasNext();
                nextA = hasA ? ait.nextLong() : Long.MAX_VALUE;
                continue;
            }
            if (nextB < nextA) {
                hasB = bit.hasNext();
                nextB = hasB ? bit.nextLong() : Long.MAX_VALUE;
                continue;
            }
            ++nshared;
            hasA = ait.hasNext();
            nextA = hasA ? ait.nextLong() : Long.MAX_VALUE;
            hasB = bit.hasNext();
            nextB = hasB ? bit.nextLong() : Long.MAX_VALUE;
        }
        return a.size() + b.size() - nshared;
    }

    public static LongSortedSet setUnion(LongSortedSet a, LongSortedSet b) {
        LongKeyDomain db;
        LongKeyDomain da;
        if (a instanceof LongSortedArraySet && b instanceof LongSortedArraySet && (da = ((LongSortedArraySet)a).getDomain()).isCompatibleWith(db = ((LongSortedArraySet)b).getDomain())) {
            LongKeyDomain result = da.clone();
            result.getActiveMask().or(db.getActiveMask());
            return result.activeSetView();
        }
        long[] data = new long[LongUtils.unionSize(a, b)];
        LongBidirectionalIterator ait = a.iterator();
        LongBidirectionalIterator bit = b.iterator();
        boolean hasA = ait.hasNext();
        boolean hasB = bit.hasNext();
        long nextA = hasA ? ait.nextLong() : Long.MAX_VALUE;
        long nextB = hasB ? bit.nextLong() : Long.MAX_VALUE;
        int i = 0;
        while (hasA || hasB) {
            if (!hasB || nextA < nextB) {
                data[i++] = nextA;
                hasA = ait.hasNext();
                nextA = hasA ? ait.nextLong() : Long.MAX_VALUE;
                continue;
            }
            if (!hasA || nextB < nextA) {
                data[i++] = nextB;
                hasB = bit.hasNext();
                nextB = hasB ? bit.nextLong() : Long.MAX_VALUE;
                continue;
            }
            data[i++] = nextA;
            hasA = ait.hasNext();
            nextA = hasA ? ait.nextLong() : Long.MAX_VALUE;
            hasB = bit.hasNext();
            nextB = hasB ? bit.nextLong() : Long.MAX_VALUE;
        }
        assert (i == data.length);
        return new LongSortedArraySet(LongKeyDomain.wrap(data, data.length, true));
    }

    private static class LongSetWrapper
    extends LongCollectionWrapper
    implements LongSet {
        LongSetWrapper(Collection<Long> base) {
            super(base);
        }

        public boolean remove(long k) {
            return super.rem(k);
        }

        public boolean equals(Object obj) {
            return this.base.equals(obj);
        }

        public int hashCode() {
            return this.base.hashCode();
        }
    }

    private static class LongCollectionWrapper
    implements LongCollection {
        protected final Collection<Long> base;

        LongCollectionWrapper(Collection<Long> b) {
            this.base = b;
        }

        public int size() {
            return this.base.size();
        }

        public boolean contains(long key) {
            return this.base.contains(key);
        }

        public LongIterator iterator() {
            return LongIterators.asLongIterator(this.base.iterator());
        }

        public boolean add(Long item) {
            return this.base.add(item);
        }

        public boolean addAll(Collection<? extends Long> items) {
            return this.base.addAll(items);
        }

        public void clear() {
            this.base.clear();
        }

        public boolean contains(Object item) {
            return this.base.contains(item);
        }

        public boolean containsAll(Collection<?> items) {
            return this.base.containsAll(items);
        }

        public boolean isEmpty() {
            return this.base.isEmpty();
        }

        public boolean remove(Object item) {
            return this.base.remove(item);
        }

        public boolean removeAll(Collection<?> items) {
            return this.base.removeAll(items);
        }

        public boolean retainAll(Collection<?> items) {
            return this.base.retainAll(items);
        }

        public Object[] toArray() {
            return this.base.toArray();
        }

        @Deprecated
        public LongIterator longIterator() {
            return this.iterator();
        }

        public <T> T[] toArray(T[] a) {
            return this.base.toArray(a);
        }

        public long[] toLongArray() {
            long[] items = new long[this.size()];
            LongIterators.unwrap((LongIterator)this.iterator(), (long[])items);
            return items;
        }

        public long[] toLongArray(long[] a) {
            int sz;
            long[] output = a;
            if (output.length < this.size()) {
                output = new long[this.size()];
            }
            if ((sz = LongIterators.unwrap((LongIterator)this.iterator(), (long[])output)) < output.length) {
                output = Arrays.copyOf(output, sz);
            }
            return output;
        }

        public long[] toArray(long[] a) {
            return this.toLongArray(a);
        }

        public boolean add(long key) {
            return this.base.add(key);
        }

        public boolean rem(long key) {
            return this.base.remove(key);
        }

        public boolean addAll(LongCollection c) {
            return this.base.addAll((Collection<Long>)c);
        }

        public boolean containsAll(LongCollection c) {
            return this.base.containsAll((Collection<?>)c);
        }

        public boolean removeAll(LongCollection c) {
            return this.base.removeAll((Collection<?>)c);
        }

        public boolean retainAll(LongCollection c) {
            return this.base.retainAll((Collection<?>)c);
        }
    }
}

