/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.collections;

import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import java.io.Serializable;
import java.util.Collection;

class ObjectCollectionWrapper<E>
implements ObjectCollection<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Collection<E> delegate;

    public ObjectCollectionWrapper(Collection<E> objects) {
        this.delegate = objects;
    }

    public ObjectIterator<E> iterator() {
        return ObjectIterators.asObjectIterator(this.delegate.iterator());
    }

    public ObjectIterator<E> objectIterator() {
        return this.iterator();
    }

    public <T> T[] toArray(T[] a) {
        if (this.size() <= a.length) {
            ObjectIterators.unwrap(this.iterator(), (Object[])a);
            return a;
        }
        return this.delegate.toArray(a);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    public Object[] toArray() {
        return this.delegate.toArray();
    }

    public boolean add(E e) {
        return this.delegate.add(e);
    }

    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    public boolean addAll(Collection<? extends E> c) {
        return this.delegate.addAll(c);
    }

    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    public void clear() {
        this.delegate.clear();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

