/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.collections;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.grouplens.lenskit.collections.AbstractIntPointer;
import org.grouplens.lenskit.collections.IntPointer;
import org.grouplens.lenskit.collections.IteratorPointer;
import org.grouplens.lenskit.collections.Pointer;

@Deprecated
public final class Pointers {
    private Pointers() {
    }

    public static IntPointer fromTo(int start, int end) {
        Preconditions.checkArgument((end >= start ? 1 : 0) != 0, (Object)"end is less than start");
        return new IntervalPointer(start, end);
    }

    public static <T, R> Pointer<R> transform(Pointer<T> pointer, Function<? super T, ? extends R> func) {
        return new TransformedPointer<T, R>(pointer, func);
    }

    public static <E> Pointer<E> fromIterator(Iterator<E> iter) {
        return new IteratorPointer<E>(iter);
    }

    private static class TransformedPointer<T, R>
    implements Pointer<R> {
        private final Pointer<T> pointer;
        private final Function<? super T, ? extends R> function;

        public TransformedPointer(Pointer<T> ptr, Function<? super T, ? extends R> func) {
            this.pointer = ptr;
            this.function = func;
        }

        @Override
        public boolean advance() {
            return this.pointer.advance();
        }

        @Override
        public R get() {
            return (R)this.function.apply(this.pointer.get());
        }

        @Override
        public boolean isAtEnd() {
            return this.pointer.isAtEnd();
        }
    }

    private static final class IntervalPointer
    extends AbstractIntPointer {
        private final int end;
        private int current;

        public IntervalPointer(int s, int e) {
            this.current = s;
            this.end = e;
        }

        @Override
        public boolean advance() {
            if (this.current < this.end) {
                ++this.current;
            }
            return this.current < this.end;
        }

        @Override
        public int getInt() {
            if (this.current < this.end) {
                return this.current;
            }
            throw new NoSuchElementException("range pointer exhausted");
        }

        @Override
        public boolean isAtEnd() {
            return this.current >= this.end;
        }
    }
}

