/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.collections;

import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.grouplens.lenskit.collections.IntPointer;
import org.grouplens.lenskit.collections.LongKeyDomain;
import org.grouplens.lenskit.collections.LongSortedArraySet;

class RemovableLongSortedArraySet
extends LongSortedArraySet {
    private static final long serialVersionUID = 1L;

    RemovableLongSortedArraySet(@Nonnull LongKeyDomain ks) {
        super(ks);
    }

    public boolean remove(long k) {
        int idx = this.keys.getIndexIfActive(k);
        if (idx >= 0) {
            this.keys.setActive(idx, false);
            return true;
        }
        return false;
    }

    private boolean removeAll(LongIterator iter) {
        boolean removed = false;
        IntPointer posPtr = this.keys.activeIndexPointer(true);
        while (iter.hasNext() && !posPtr.isAtEnd()) {
            long rmk = iter.nextLong();
            while (!posPtr.isAtEnd() && this.keys.getKey(posPtr.getInt()) < rmk) {
                posPtr.advance();
            }
            if (posPtr.isAtEnd() || this.keys.getKey(posPtr.getInt()) != rmk) continue;
            this.keys.setActive(posPtr.getInt(), false);
            removed = true;
        }
        return removed;
    }

    public boolean removeAll(LongCollection c) {
        if (c instanceof LongSortedSet) {
            return this.removeAll(c.iterator());
        }
        long[] longs = c.toLongArray();
        Arrays.sort(longs);
        return this.removeAll((LongIterator)LongArrayList.wrap((long[])longs).iterator());
    }

    public boolean removeAll(Collection<?> c) {
        if (c instanceof LongCollection) {
            return this.removeAll((LongCollection)c);
        }
        long[] longs = LongIterators.unwrap((LongIterator)LongIterators.asLongIterator((Iterator)Iterators.filter(c.iterator(), Long.class)));
        Arrays.sort(longs);
        return this.removeAll((LongIterator)LongArrayList.wrap((long[])longs).iterator());
    }

    private boolean retainAll(LongIterator iter) {
        boolean removed = false;
        IntPointer posPtr = this.keys.activeIndexPointer(true);
        while (iter.hasNext() && !posPtr.isAtEnd()) {
            long rmk = iter.nextLong();
            while (!posPtr.isAtEnd() && this.keys.getKey(posPtr.getInt()) < rmk) {
                this.keys.setActive(posPtr.getInt(), false);
                removed = true;
                posPtr.advance();
            }
            if (posPtr.isAtEnd() || this.keys.getKey(posPtr.getInt()) != rmk) continue;
            posPtr.advance();
        }
        return removed;
    }

    public boolean retainAll(LongCollection c) {
        if (c instanceof LongSortedSet) {
            return this.retainAll(c.iterator());
        }
        long[] longs = c.toLongArray();
        Arrays.sort(longs);
        return this.retainAll((LongIterator)LongArrayList.wrap((long[])longs).iterator());
    }

    public boolean retainAll(Collection<?> c) {
        if (c instanceof LongCollection) {
            return this.retainAll((LongCollection)c);
        }
        long[] longs = LongIterators.unwrap((LongIterator)LongIterators.asLongIterator((Iterator)Iterators.filter(c.iterator(), Long.class)));
        Arrays.sort(longs);
        return this.retainAll((LongIterator)LongArrayList.wrap((long[])longs).iterator());
    }
}

