/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.cursors;

import java.util.Iterator;
import javax.annotation.Nonnull;
import org.grouplens.lenskit.cursors.Cursor;
import org.grouplens.lenskit.cursors.CursorIterator;

public abstract class AbstractCursor<T>
implements Cursor<T> {
    private final int rowCount;

    public AbstractCursor() {
        this(-1);
    }

    public AbstractCursor(int nrows) {
        this.rowCount = Math.max(nrows, -1);
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public void close() {
    }

    @Override
    @Nonnull
    public T fastNext() {
        return this.next();
    }

    @Override
    public Iterable<T> fast() {
        return new FastIterable();
    }

    @Override
    public Iterator<T> iterator() {
        return new CursorIterator(this);
    }

    private class FastIterable
    implements Iterable<T> {
        private FastIterable() {
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return AbstractCursor.this.hasNext();
                }

                @Override
                public T next() {
                    return AbstractCursor.this.fastNext();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

