/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.cursors;

import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.grouplens.lenskit.cursors.AbstractCursor;

public abstract class AbstractPollingCursor<T>
extends AbstractCursor<T> {
    private boolean hasNextCalled;
    private T polled;

    public AbstractPollingCursor() {
    }

    public AbstractPollingCursor(int rowCount) {
        super(rowCount);
    }

    @Override
    public boolean hasNext() {
        if (!this.hasNextCalled) {
            this.polled = this.poll();
            this.hasNextCalled = true;
        }
        return this.polled != null;
    }

    @Override
    @Nonnull
    public T fastNext() {
        if (!this.hasNextCalled) {
            this.polled = this.poll();
        }
        if (this.polled == null) {
            throw new NoSuchElementException();
        }
        T n = this.polled;
        this.polled = null;
        this.hasNextCalled = false;
        return n;
    }

    @Override
    @Nonnull
    public T next() {
        return this.copy(this.fastNext());
    }

    protected abstract T poll();

    protected T copy(T obj) {
        return obj;
    }
}

