/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.cursors;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.annotation.WillCloseWhenClosed;
import org.grouplens.lenskit.cursors.AbstractPollingCursor;
import org.grouplens.lenskit.cursors.Cursor;
import org.grouplens.lenskit.cursors.FilteredCursor;
import org.grouplens.lenskit.cursors.IteratorCursor;
import org.grouplens.lenskit.cursors.LongCursor;
import org.grouplens.lenskit.cursors.LongCursorIterator;
import org.grouplens.lenskit.cursors.LongIteratorCursor;
import org.grouplens.lenskit.cursors.TransformedCursor;

public final class Cursors {
    private static final int DEFAULT_LIST_SIZE = 20;

    private Cursors() {
    }

    public static <T> Cursor<T> wrap(Iterator<? extends T> iterator) {
        return new IteratorCursor<T>(iterator, -1);
    }

    public static <T> Cursor<T> wrap(Collection<? extends T> collection) {
        return new IteratorCursor<T>(collection.iterator(), collection.size());
    }

    public static <T> Cursor<T> filter(@WillCloseWhenClosed Cursor<T> cursor, Predicate<? super T> predicate) {
        return new FilteredCursor<T>(cursor, predicate);
    }

    public static <T> Cursor<T> filter(final @WillCloseWhenClosed Cursor<?> cursor, final Class<T> type) {
        return new AbstractPollingCursor<T>(){

            @Override
            protected T poll() {
                while (cursor.hasNext()) {
                    Object obj = cursor.next();
                    if (!type.isInstance(obj)) continue;
                    return obj;
                }
                return null;
            }

            @Override
            public void close() {
                cursor.close();
            }
        };
    }

    public static <S, T> Cursor<T> transform(@WillCloseWhenClosed Cursor<S> cursor, Function<? super S, ? extends T> function) {
        return new TransformedCursor<S, T>(cursor, function);
    }

    public static <T> Cursor<T> empty() {
        return Cursors.wrap(Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> ArrayList<T> makeList(@WillClose Cursor<? extends T> cursor) {
        ArrayList list;
        try {
            int n = cursor.getRowCount();
            if (n < 0) {
                n = 20;
            }
            list = new ArrayList(n);
            for (Object item : cursor) {
                list.add(item);
            }
        }
        finally {
            cursor.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static LongArrayList makeList(@WillClose LongCursor cursor) {
        LongArrayList list = null;
        try {
            int n = cursor.getRowCount();
            if (n < 0) {
                n = 20;
            }
            list = new LongArrayList(n);
            while (cursor.hasNext()) {
                list.add(cursor.nextLong());
            }
        }
        finally {
            cursor.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static LongSet makeSet(@WillClose LongCursor cursor) {
        LongOpenHashSet set = null;
        try {
            int n = cursor.getRowCount();
            if (n < 0) {
                n = 20;
            }
            set = new LongOpenHashSet(n);
            while (cursor.hasNext()) {
                set.add(cursor.nextLong());
            }
        }
        finally {
            cursor.close();
        }
        set.trim();
        return set;
    }

    @Deprecated
    public static LongCursor wrap(LongIterator iter) {
        return new LongIteratorCursor(iter);
    }

    @Deprecated
    public static LongCursor wrap(LongCollection collection) {
        return new LongIteratorCursor(collection.iterator(), collection.size());
    }

    @Deprecated
    public static LongCursor makeLongCursor(@WillCloseWhenClosed Cursor<Long> cursor) {
        if (cursor instanceof LongCursor) {
            return (LongCursor)cursor;
        }
        return new UnboxingLongCursor(cursor);
    }

    public static <T> Cursor<T> sort(@WillClose Cursor<T> cursor, Comparator<? super T> comp) {
        ArrayList<T> list = Cursors.makeList(cursor);
        Collections.sort(list, comp);
        return Cursors.wrap(list);
    }

    private static class UnboxingLongCursor
    implements LongCursor {
        private final Cursor<Long> cursor;

        public UnboxingLongCursor(Cursor<Long> cursor) {
            this.cursor = cursor;
        }

        @Override
        public boolean hasNext() {
            return this.cursor.hasNext();
        }

        @Override
        @Nonnull
        public Long next() {
            return this.cursor.next();
        }

        @Override
        @Nonnull
        public Long fastNext() {
            return this.cursor.fastNext();
        }

        public LongIterable fast() {
            return this;
        }

        @Override
        public long nextLong() {
            return this.next();
        }

        @Override
        public void close() {
            this.cursor.close();
        }

        @Override
        public int getRowCount() {
            return this.cursor.getRowCount();
        }

        public LongIterator iterator() {
            return new LongCursorIterator(this);
        }
    }
}

