/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.cursors;

import com.google.common.base.Predicate;
import javax.annotation.WillCloseWhenClosed;
import org.grouplens.lenskit.cursors.AbstractPollingCursor;
import org.grouplens.lenskit.cursors.Cursor;

class FilteredCursor<T>
extends AbstractPollingCursor<T> {
    private final Cursor<T> cursor;
    private final Predicate<? super T> filter;

    public FilteredCursor(@WillCloseWhenClosed Cursor<T> cur, Predicate<? super T> filt) {
        this.cursor = cur;
        this.filter = filt;
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    @Override
    protected T poll() {
        while (this.cursor.hasNext()) {
            T next = this.cursor.next();
            if (!this.filter.apply(next)) continue;
            return next;
        }
        return null;
    }
}

