/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.cursors;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.grouplens.lenskit.cursors.AbstractCursor;

class IteratorCursor<T>
extends AbstractCursor<T> {
    private Iterator<? extends T> iterator;

    public IteratorCursor(@Nonnull Iterator<? extends T> iter, int size) {
        super(size);
        Preconditions.checkNotNull(iter, (Object)"iterator for cursor");
        this.iterator = iter;
    }

    @Override
    public boolean hasNext() {
        return this.iterator != null && this.iterator.hasNext();
    }

    @Override
    @Nonnull
    public T next() {
        if (this.iterator == null) {
            throw new IllegalStateException("cursor closed");
        }
        return this.iterator.next();
    }

    @Override
    public void close() {
        super.close();
        this.iterator = null;
    }
}

