/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.scored;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.grouplens.lenskit.scored.ScoredId;
import org.grouplens.lenskit.symbols.DoubleSymbolValue;
import org.grouplens.lenskit.symbols.Symbol;
import org.grouplens.lenskit.symbols.SymbolValue;
import org.grouplens.lenskit.symbols.TypedSymbol;

public abstract class AbstractScoredId
implements ScoredId {
    private volatile transient int hashCode;
    private volatile transient String stringRepr;

    public String toString() {
        if (this.stringRepr == null) {
            StringBuilder bld = new StringBuilder();
            bld.append("score(").append(this.getId()).append(") = ").append(this.getScore());
            int nchans = this.getChannels().size();
            if (nchans > 0) {
                bld.append(" [with ").append(nchans).append(" channels]");
            }
            this.stringRepr = bld.toString();
        }
        return this.stringRepr;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeBuilder builder = new HashCodeBuilder().append(this.getId()).append(this.getScore());
            double sum = 0.0;
            for (SymbolValue<?> sym : this.getChannels()) {
                sum += (double)sym.hashCode();
            }
            builder.append(sum);
            this.hashCode = builder.build();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ScoredId) {
            ScoredId oid = (ScoredId)o;
            Ordering ord = Ordering.arbitrary().onResultOf(SymbolValue.extractSymbol());
            return new EqualsBuilder().append(this.getId(), oid.getId()).append(this.getScore(), oid.getScore()).append((Object)ord.sortedCopy(this.getChannels()), (Object)ord.sortedCopy(oid.getChannels())).isEquals();
        }
        return false;
    }

    @Override
    @Nonnull
    public Collection<DoubleSymbolValue> getUnboxedChannels() {
        return FluentIterable.from(this.getChannels()).filter(DoubleSymbolValue.class).toList();
    }

    @Override
    public Set<TypedSymbol<?>> getChannelSymbols() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (SymbolValue<?> sv : this.getChannels()) {
            builder.add(sv.getSymbol());
        }
        return builder.build();
    }

    @Override
    public Set<Symbol> getUnboxedChannelSymbols() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (SymbolValue symbolValue : this.getUnboxedChannels()) {
            builder.add((Object)symbolValue.getRawSymbol());
        }
        return builder.build();
    }

    @Override
    public boolean hasChannel(TypedSymbol<?> sym) {
        for (SymbolValue<?> val : this.getChannels()) {
            if (sym != val.getSymbol()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasUnboxedChannel(Symbol sym) {
        return this.hasChannel(sym.withType(Double.class));
    }

    @Override
    @Deprecated
    public boolean hasChannel(Symbol sym) {
        return this.hasUnboxedChannel(sym);
    }

    @Override
    @Deprecated
    public double channel(Symbol sym) {
        try {
            return this.getUnboxedChannelValue(sym);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("unknown symbol " + sym, e);
        }
    }

    @Override
    @Deprecated
    public <T> T channel(TypedSymbol<T> sym) {
        T obj = this.getChannelValue(sym);
        if (obj == null) {
            throw new IllegalArgumentException("unknown symbol " + sym);
        }
        return obj;
    }
}

