/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.scored;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.grouplens.lenskit.collections.FastCollection;
import org.grouplens.lenskit.scored.AbstractScoredId;
import org.grouplens.lenskit.scored.ScoredId;
import org.grouplens.lenskit.scored.ScoredIds;
import org.grouplens.lenskit.symbols.DoubleSymbolValue;
import org.grouplens.lenskit.symbols.Symbol;
import org.grouplens.lenskit.symbols.SymbolValue;
import org.grouplens.lenskit.symbols.TypedSymbol;

public final class PackedScoredIdList
extends AbstractList<ScoredId>
implements FastCollection<ScoredId>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long[] ids;
    private final double[] scores;
    private final Map<Symbol, double[]> unboxedChannels;
    private final Map<TypedSymbol<?>, Object[]> channels;

    PackedScoredIdList(long[] ids, double[] scores, Map<TypedSymbol<?>, Object[]> chans, Map<Symbol, double[]> unboxedChans) {
        assert (ids.length == scores.length);
        this.ids = ids;
        this.scores = scores;
        this.unboxedChannels = unboxedChans;
        this.channels = chans;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.ids.length != this.scores.length) {
            throw new InvalidObjectException("score array has incorrect size");
        }
        for (double[] dArray : this.unboxedChannels.values()) {
            if (dArray.length == this.ids.length) continue;
            throw new InvalidObjectException("channel array has incorrect size");
        }
        for (Map.Entry entry : this.channels.entrySet()) {
            if (((Object[])entry.getValue()).length != this.ids.length) {
                throw new InvalidObjectException("channel array has incorrect size");
            }
            if (((TypedSymbol)entry.getKey()).getType().isAssignableFrom(((Object[])entry.getValue()).getClass().getComponentType())) continue;
            throw new InvalidObjectException("channel array has incorrect type");
        }
    }

    @Override
    public int size() {
        return this.ids.length;
    }

    @Override
    public Iterator<ScoredId> fastIterator() {
        return new FastIter();
    }

    @Override
    public ScoredId get(int i) {
        Preconditions.checkElementIndex((int)i, (int)this.size());
        return this.getFlyweight(i);
    }

    IndirectScoredId getFlyweight(int i) {
        return new IndirectScoredId(i);
    }

    private class FastIter
    implements Iterator<ScoredId> {
        int next = 0;
        IndirectScoredId id = new IndirectScoredId(0);

        private FastIter() {
        }

        @Override
        public boolean hasNext() {
            return this.next < PackedScoredIdList.this.ids.length;
        }

        @Override
        public ScoredId next() {
            if (this.next < PackedScoredIdList.this.ids.length) {
                this.id.setIndex(this.next);
                ++this.next;
                return this.id;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("packed scored ID lists are immutable");
        }
    }

    class IndirectScoredId
    extends AbstractScoredId
    implements Serializable {
        private int index;

        public IndirectScoredId(int idx) {
            this.index = idx;
        }

        public Object writeReplace() {
            return ScoredIds.copyBuilder(this).build();
        }

        public void setIndex(int idx) {
            this.index = idx;
        }

        @Override
        public long getId() {
            return PackedScoredIdList.this.ids[this.index];
        }

        @Override
        public double getScore() {
            return PackedScoredIdList.this.scores[this.index];
        }

        @Override
        public Set<Symbol> getUnboxedChannelSymbols() {
            return PackedScoredIdList.this.unboxedChannels.keySet();
        }

        @Override
        public Set<TypedSymbol<?>> getChannelSymbols() {
            ImmutableSet.Builder bld = ImmutableSet.builder();
            for (Symbol symbol : PackedScoredIdList.this.unboxedChannels.keySet()) {
                bld.add(symbol.withType(Double.class));
            }
            for (Map.Entry entry : PackedScoredIdList.this.channels.entrySet()) {
                if (((Object[])entry.getValue())[this.index] == null) continue;
                bld.add(entry.getKey());
            }
            return bld.build();
        }

        @Override
        @Nonnull
        public Collection<SymbolValue<?>> getChannels() {
            ArrayList channels = Lists.newArrayList();
            FluentIterable.from(PackedScoredIdList.this.channels.entrySet()).transform(new Function<Map.Entry<TypedSymbol<?>, Object[]>, SymbolValue<?>>(){

                @Nullable
                public SymbolValue<?> apply(@Nullable Map.Entry<TypedSymbol<?>, Object[]> input) {
                    assert (input != null);
                    Object obj = input.getValue()[IndirectScoredId.this.index];
                    if (obj != null) {
                        TypedSymbol<?> sym = input.getKey();
                        assert (sym.getType().isInstance(obj));
                        return sym.withValue(obj);
                    }
                    return null;
                }
            }).filter(Predicates.notNull()).copyInto((Collection)channels);
            channels.addAll(this.getUnboxedChannels());
            return channels;
        }

        @Override
        @Nonnull
        public Collection<DoubleSymbolValue> getUnboxedChannels() {
            return Collections2.transform(PackedScoredIdList.this.unboxedChannels.entrySet(), (Function)new Function<Map.Entry<Symbol, double[]>, DoubleSymbolValue>(){

                @Nullable
                public DoubleSymbolValue apply(@Nullable Map.Entry<Symbol, double[]> input) {
                    assert (input != null);
                    return SymbolValue.of(input.getKey(), input.getValue()[IndirectScoredId.this.index]);
                }
            });
        }

        @Override
        @Nullable
        public <T> T getChannelValue(@Nonnull TypedSymbol<T> sym) {
            if (sym.getType().equals(Double.class) && this.hasUnboxedChannel(sym.getRawSymbol())) {
                return sym.getType().cast(this.getUnboxedChannelValue(sym.getRawSymbol()));
            }
            Object[] array = (Object[])PackedScoredIdList.this.channels.get(sym);
            if (array == null) {
                return null;
            }
            return sym.getType().cast(array[this.index]);
        }

        @Override
        public double getUnboxedChannelValue(Symbol sym) {
            double[] array = (double[])PackedScoredIdList.this.unboxedChannels.get(sym);
            if (array != null) {
                return array[this.index];
            }
            throw new NullPointerException("no symbol " + sym);
        }

        @Override
        public boolean hasUnboxedChannel(Symbol s) {
            return PackedScoredIdList.this.unboxedChannels.containsKey(s);
        }

        @Override
        public boolean hasChannel(TypedSymbol<?> s) {
            if (s.getType().equals(Double.class) && this.hasUnboxedChannel(s.getRawSymbol())) {
                return true;
            }
            Object[] obj = (Object[])PackedScoredIdList.this.channels.get(s);
            return obj != null && obj[this.index] != null;
        }
    }
}

