/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.scored;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.Builder;
import org.grouplens.lenskit.scored.ScoredId;
import org.grouplens.lenskit.scored.ScoredIdImpl;
import org.grouplens.lenskit.symbols.DoubleSymbolValue;
import org.grouplens.lenskit.symbols.Symbol;
import org.grouplens.lenskit.symbols.SymbolValue;
import org.grouplens.lenskit.symbols.TypedSymbol;

public class ScoredIdBuilder
implements Builder<ScoredId> {
    private long id;
    private double score;
    private List<SymbolValue<?>> channels;

    public ScoredIdBuilder() {
        this(0L, 0.0);
    }

    public ScoredIdBuilder(long id) {
        this(id, 0.0);
    }

    public ScoredIdBuilder(long id, double score) {
        this.id = id;
        this.score = score;
        this.channels = Lists.newLinkedList();
    }

    public ScoredIdBuilder setId(long id) {
        this.id = id;
        return this;
    }

    public ScoredIdBuilder setScore(double score) {
        this.score = score;
        return this;
    }

    public ScoredIdBuilder addChannel(Symbol symbol, double value) {
        Preconditions.checkNotNull((Object)symbol, (Object)"symbol cannot be null");
        DoubleSymbolValue sv = SymbolValue.of(symbol, value);
        Iterators.removeIf(this.channels.iterator(), SymbolValue.hasSymbol(sv.getSymbol()));
        this.channels.add(sv);
        return this;
    }

    public <K> ScoredIdBuilder addChannel(@Nonnull TypedSymbol<K> symbol, @Nonnull K value) {
        Preconditions.checkNotNull(symbol, (Object)"symbol cannot be null");
        Preconditions.checkNotNull(value, (Object)"value cannot be null");
        Preconditions.checkArgument((boolean)symbol.getType().isInstance(value), (Object)("value is not of type " + symbol.getType()));
        SymbolValue<K> val = SymbolValue.of(symbol, value);
        Iterators.removeIf(this.channels.iterator(), SymbolValue.hasSymbol(symbol));
        this.channels.add(val);
        return this;
    }

    public ScoredIdBuilder clearChannels() {
        this.channels.clear();
        return this;
    }

    public ScoredId build() {
        return new ScoredIdImpl(this.id, this.score, this.channels);
    }
}

