/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.scored;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.grouplens.lenskit.scored.AbstractScoredId;
import org.grouplens.lenskit.symbols.DoubleSymbolValue;
import org.grouplens.lenskit.symbols.Symbol;
import org.grouplens.lenskit.symbols.SymbolValue;
import org.grouplens.lenskit.symbols.TypedSymbol;

final class ScoredIdImpl
extends AbstractScoredId
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final long id;
    private final double score;
    @Nonnull
    private final List<SymbolValue<?>> channels;
    private volatile transient List<DoubleSymbolValue> unboxedChannels;

    public ScoredIdImpl(long id, double score) {
        this(id, score, Collections.emptyList());
    }

    public ScoredIdImpl(long id, double score, @Nonnull Collection<? extends SymbolValue<?>> chans) {
        this.id = id;
        this.score = score;
        this.channels = ImmutableList.copyOf(chans);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public double getScore() {
        return this.score;
    }

    @Override
    @Nonnull
    public Collection<SymbolValue<?>> getChannels() {
        return this.channels;
    }

    @Override
    @Nonnull
    public Collection<DoubleSymbolValue> getUnboxedChannels() {
        if (this.unboxedChannels == null) {
            this.unboxedChannels = FluentIterable.from(this.channels).filter(DoubleSymbolValue.class).toList();
        }
        return this.unboxedChannels;
    }

    @Override
    @Nullable
    public <T> T getChannelValue(@Nonnull TypedSymbol<T> sym) {
        for (SymbolValue<?> channel : this.channels) {
            if (sym != channel.getSymbol()) continue;
            assert (sym.getType().isInstance(channel.getValue()));
            return (T)channel.getValue();
        }
        return null;
    }

    @Override
    public double getUnboxedChannelValue(Symbol sym) {
        for (DoubleSymbolValue channel : this.getUnboxedChannels()) {
            if (sym != channel.getSymbol().getRawSymbol()) continue;
            return channel.getDoubleValue();
        }
        throw new NullPointerException("no such symbol " + sym);
    }
}

