/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.scored;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.Builder;
import org.grouplens.lenskit.collections.CollectionUtils;
import org.grouplens.lenskit.scored.PackedScoredIdList;
import org.grouplens.lenskit.scored.ScoredId;
import org.grouplens.lenskit.symbols.DoubleSymbolValue;
import org.grouplens.lenskit.symbols.Symbol;
import org.grouplens.lenskit.symbols.SymbolValue;
import org.grouplens.lenskit.symbols.TypedSymbol;

public class ScoredIdListBuilder
implements Builder<PackedScoredIdList> {
    private long[] ids;
    private double[] scores;
    private boolean ignoreUnknown = false;
    private int size;
    private Map<Symbol, ChannelStorage> channels;
    private Map<TypedSymbol<?>, TypedChannelStorage<?>> typedChannels;

    public ScoredIdListBuilder() {
        this(10);
    }

    public ScoredIdListBuilder(int cap) {
        this.initialize(cap);
    }

    private void initialize(int cap) {
        this.ids = new long[cap];
        this.scores = new double[cap];
        this.size = 0;
        this.channels = new Reference2ObjectArrayMap();
        this.typedChannels = new Reference2ObjectArrayMap();
    }

    public PackedScoredIdList build() {
        return this.finish(false);
    }

    public PackedScoredIdList finish() {
        return this.finish(true);
    }

    private PackedScoredIdList finish(boolean tryReuse) {
        double[] builtScores;
        ImmutableMap typedChans;
        ImmutableMap chans;
        boolean reuse;
        Preconditions.checkState((this.ids != null ? 1 : 0) != 0, (Object)"builder has been finished");
        boolean bl = reuse = tryReuse && this.size == this.capacity();
        if (this.size > 0) {
            ImmutableMap.Builder cbld = ImmutableMap.builder();
            for (ChannelStorage chan : this.channels.values()) {
                double[] built = reuse ? chan.values : Arrays.copyOf(chan.values, this.size);
                cbld.put((Object)chan.symbol, (Object)built);
            }
            chans = cbld.build();
            ImmutableMap.Builder tcbld = ImmutableMap.builder();
            for (TypedChannelStorage<?> chan : this.typedChannels.values()) {
                Object[] built;
                Object[] objectArray = built = reuse ? ((TypedChannelStorage)chan).values : Arrays.copyOf(((TypedChannelStorage)chan).values, this.size);
                assert (((TypedChannelStorage)chan).symbol.getType().isAssignableFrom(built.getClass().getComponentType()));
                tcbld.put((Object)((TypedChannelStorage)chan).symbol, (Object)built);
            }
            typedChans = tcbld.build();
        } else {
            chans = Collections.emptyMap();
            typedChans = Collections.emptyMap();
        }
        long[] builtIds = reuse ? this.ids : Arrays.copyOf(this.ids, this.size);
        double[] dArray = builtScores = reuse ? this.scores : Arrays.copyOf(this.scores, this.size);
        if (tryReuse) {
            this.ids = null;
            this.scores = null;
            this.channels = null;
            this.typedChannels = null;
        }
        return new PackedScoredIdList(builtIds, builtScores, (Map<TypedSymbol<?>, Object[]>)typedChans, (Map<Symbol, double[]>)chans);
    }

    private int capacity() {
        return this.ids.length;
    }

    public int size() {
        return this.size;
    }

    private void requireCapacity(int sz) {
        if (sz > this.capacity()) {
            int newCap = Math.max(sz, this.capacity() * 2);
            this.ids = Arrays.copyOf(this.ids, newCap);
            this.scores = Arrays.copyOf(this.scores, newCap);
            for (ChannelStorage channelStorage : this.channels.values()) {
                channelStorage.resize(newCap);
            }
            for (TypedChannelStorage typedChannelStorage : this.typedChannels.values()) {
                typedChannelStorage.resize(newCap);
            }
            assert (this.capacity() == newCap);
        }
    }

    public ScoredIdListBuilder add(long id, double score) {
        Preconditions.checkState((this.ids != null ? 1 : 0) != 0, (Object)"builder has been finished");
        int idx = this.size++;
        this.requireCapacity(idx + 1);
        this.ids[idx] = id;
        this.scores[idx] = score;
        return this;
    }

    public ScoredIdListBuilder add(ScoredId id) {
        Preconditions.checkState((this.ids != null ? 1 : 0) != 0, (Object)"builder has been finished");
        Collection<SymbolValue<?>> chans = id.getChannels();
        if (!this.ignoreUnknown) {
            for (SymbolValue<?> chan : chans) {
                TypedSymbol<?> sym = chan.getSymbol();
                boolean good = sym.getType().equals(Double.class) ? this.channels.containsKey(sym.getRawSymbol()) : this.typedChannels.containsKey(sym);
                if (good) continue;
                throw new IllegalArgumentException("channel " + sym + " not known");
            }
        }
        int idx = this.size;
        this.add(id.getId(), id.getScore());
        for (SymbolValue<?> sv : chans) {
            TypedChannelStorage<?> chan;
            TypedSymbol<?> sym = sv.getSymbol();
            if (sym.getType().equals(Double.class) && this.channels.containsKey(sym.getRawSymbol())) {
                chan = this.channels.get(sym.getRawSymbol());
                if (sv instanceof DoubleSymbolValue) {
                    ((ChannelStorage)((Object)chan)).values[idx] = ((DoubleSymbolValue)sv).getDoubleValue();
                    continue;
                }
                Object v = sv.getValue();
                ((ChannelStorage)((Object)chan)).values[idx] = (Double)v;
                continue;
            }
            chan = this.typedChannels.get(sv.getSymbol());
            if (chan == null) continue;
            ((TypedChannelStorage)chan).values[idx] = sv.getValue();
        }
        return this;
    }

    public ScoredIdListBuilder addAll(Iterable<ScoredId> ids) {
        Preconditions.checkState((ids != null ? 1 : 0) != 0, (Object)"builder has been finished");
        if (ids instanceof Collection) {
            this.requireCapacity(this.size + ((Collection)ids).size());
        }
        for (ScoredId id : CollectionUtils.fast(ids)) {
            this.add(id);
        }
        return this;
    }

    public ScoredIdListBuilder addChannel(Symbol sym) {
        return this.addChannel(sym, 0.0);
    }

    public ScoredIdListBuilder addChannel(Symbol sym, double dft) {
        Preconditions.checkState((this.ids != null ? 1 : 0) != 0, (Object)"builder has been finished");
        if (this.channels.containsKey(sym)) {
            throw new IllegalArgumentException(sym + " already in the builder");
        }
        this.channels.put(sym, new ChannelStorage(sym, dft));
        return this;
    }

    public ScoredIdListBuilder addChannels(Iterable<Symbol> channels) {
        for (Symbol sym : channels) {
            this.addChannel(sym);
        }
        return this;
    }

    public ScoredIdListBuilder addChannel(TypedSymbol<?> sym) {
        return this.addChannel(sym, null);
    }

    public <T> ScoredIdListBuilder addChannel(TypedSymbol<T> sym, T dft) {
        Preconditions.checkState((this.ids != null ? 1 : 0) != 0, (Object)"builder has been finished");
        if (this.typedChannels.containsKey(sym)) {
            throw new IllegalArgumentException(sym + " already in the builder");
        }
        this.typedChannels.put(sym, new TypedChannelStorage(sym, dft));
        return this;
    }

    public ScoredIdListBuilder addTypedChannels(Iterable<? extends TypedSymbol<?>> channels) {
        for (TypedSymbol<?> sym : channels) {
            this.addChannel(sym);
        }
        return this;
    }

    public ScoredIdListBuilder ignoreUnknownChannels() {
        this.ignoreUnknown = true;
        return this;
    }

    public ScoredIdListBuilder failOnUnknownChannels() {
        this.ignoreUnknown = false;
        return this;
    }

    public ScoredIdListBuilder sort(Comparator<ScoredId> order) {
        Preconditions.checkState((this.ids != null ? 1 : 0) != 0, (Object)"builder has been finished");
        it.unimi.dsi.fastutil.Arrays.quickSort((int)0, (int)this.size, (IntComparator)new SortComp(order), (Swapper)new SortSwap());
        return this;
    }

    private static void doSwap(long[] longs, int i, int j) {
        long tmp = longs[i];
        longs[i] = longs[j];
        longs[j] = tmp;
    }

    private static void doSwap(double[] doubles, int i, int j) {
        double tmp = doubles[i];
        doubles[i] = doubles[j];
        doubles[j] = tmp;
    }

    private static <T> void doSwap(T[] objs, int i, int j) {
        T tmp = objs[i];
        objs[i] = objs[j];
        objs[j] = tmp;
    }

    private class TypedChannelStorage<T> {
        private final TypedSymbol<T> symbol;
        private final T defaultValue;
        private T[] values;

        private TypedChannelStorage(TypedSymbol<T> sym, T dft) {
            this.symbol = sym;
            this.defaultValue = dft;
            this.values = (Object[])Array.newInstance(sym.getType(), ScoredIdListBuilder.this.capacity());
            if (this.defaultValue != null) {
                ObjectArrays.fill((Object[])this.values, this.defaultValue);
            }
        }

        void resize(int size) {
            Preconditions.checkArgument((size > this.values.length ? 1 : 0) != 0);
            int oldSize = this.values.length;
            this.values = Arrays.copyOf(this.values, size);
            if (this.defaultValue != null) {
                ObjectArrays.fill((Object[])this.values, (int)oldSize, (int)size, this.defaultValue);
            }
        }
    }

    private class ChannelStorage {
        private final Symbol symbol;
        private final double defaultValue;
        private double[] values;

        public ChannelStorage(Symbol sym, double dft) {
            this.symbol = sym;
            this.defaultValue = dft;
            this.values = new double[ScoredIdListBuilder.this.capacity()];
            if (this.defaultValue != 0.0) {
                DoubleArrays.fill((double[])this.values, (double)this.defaultValue);
            }
        }

        void resize(int size) {
            Preconditions.checkArgument((size > this.values.length ? 1 : 0) != 0);
            int oldSize = this.values.length;
            this.values = Arrays.copyOf(this.values, size);
            if (this.defaultValue != 0.0) {
                DoubleArrays.fill((double[])this.values, (int)oldSize, (int)size, (double)this.defaultValue);
            }
        }
    }

    private class SortSwap
    implements Swapper {
        private SortSwap() {
        }

        public void swap(int i, int j) {
            ScoredIdListBuilder.doSwap(ScoredIdListBuilder.this.ids, i, j);
            ScoredIdListBuilder.doSwap(ScoredIdListBuilder.this.scores, i, j);
            for (Object chan : ScoredIdListBuilder.this.channels.values()) {
                ScoredIdListBuilder.doSwap(((ChannelStorage)chan).values, i, j);
            }
            for (Object chan : ScoredIdListBuilder.this.typedChannels.values()) {
                ScoredIdListBuilder.doSwap(((TypedChannelStorage)chan).values, i, j);
            }
        }
    }

    private class SortComp
    extends AbstractIntComparator {
        private final Comparator<ScoredId> order;
        private PackedScoredIdList.IndirectScoredId id1;
        private PackedScoredIdList.IndirectScoredId id2;

        public SortComp(Comparator<ScoredId> o) {
            this.order = o;
            HashMap chanMap = Maps.newHashMap();
            for (ChannelStorage chan : ScoredIdListBuilder.this.channels.values()) {
                chanMap.put(chan.symbol, chan.values);
            }
            HashMap typedMap = Maps.newHashMap();
            for (TypedChannelStorage chan : ScoredIdListBuilder.this.typedChannels.values()) {
                typedMap.put(chan.symbol, chan.values);
            }
            PackedScoredIdList list = new PackedScoredIdList(ScoredIdListBuilder.this.ids, ScoredIdListBuilder.this.scores, typedMap, chanMap);
            this.id1 = list.getFlyweight(0);
            this.id2 = list.getFlyweight(0);
        }

        public int compare(int i1, int i2) {
            this.id1.setIndex(i1);
            this.id2.setIndex(i2);
            return this.order.compare(this.id1, this.id2);
        }
    }
}

