/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.scored;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.grouplens.lenskit.collections.CopyingFastCollection;
import org.grouplens.lenskit.collections.FastCollection;
import org.grouplens.lenskit.scored.ScoredId;
import org.grouplens.lenskit.scored.ScoredIdBuilder;
import org.grouplens.lenskit.scored.ScoredIdImpl;
import org.grouplens.lenskit.scored.ScoredIdListBuilder;
import org.grouplens.lenskit.scored.VectorEntryScoredId;
import org.grouplens.lenskit.symbols.Symbol;
import org.grouplens.lenskit.symbols.TypedSymbol;
import org.grouplens.lenskit.vectors.SparseVector;
import org.grouplens.lenskit.vectors.VectorEntry;

public final class ScoredIds {
    private static final Ordering<ScoredId> ID_ORDER = new IdOrder();
    private static final Ordering<ScoredId> SCORE_ORDER = new ScoreOrder();

    private ScoredIds() {
    }

    public static ScoredIdBuilder copyBuilder(ScoredId id) {
        ScoredIdBuilder bld = new ScoredIdBuilder(id.getId(), id.getScore());
        for (Symbol symbol : id.getUnboxedChannelSymbols()) {
            bld.addChannel(symbol, id.channel(symbol));
        }
        for (TypedSymbol typedSymbol : id.getChannelSymbols()) {
            bld.addChannel(typedSymbol, id.channel(typedSymbol));
        }
        return bld;
    }

    public static ScoredIdBuilder newBuilder() {
        return new ScoredIdBuilder();
    }

    public static ScoredIdListBuilder newListBuilder() {
        return new ScoredIdListBuilder();
    }

    public static ScoredIdListBuilder newListBuilder(int cap) {
        return new ScoredIdListBuilder(cap);
    }

    public static ScoredId create(long id, double score) {
        return new ScoredIdImpl(id, score);
    }

    public static Function<ScoredId, Long> idFunction() {
        return IdFunction.INSTANCE;
    }

    public static Ordering<ScoredId> idOrder() {
        return ID_ORDER;
    }

    public static Ordering<ScoredId> scoreOrder() {
        return SCORE_ORDER;
    }

    public static Ordering<ScoredId> channelOrder(final Symbol chan) {
        return new Ordering<ScoredId>(){

            public int compare(@Nullable ScoredId left, @Nullable ScoredId right) {
                if (left.hasUnboxedChannel(chan)) {
                    if (right.hasUnboxedChannel(chan)) {
                        return Doubles.compare((double)left.channel(chan), (double)right.channel(chan));
                    }
                    return 1;
                }
                if (right.hasUnboxedChannel(chan)) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public static <T extends Comparable<? super T>> Ordering<ScoredId> channelOrder(TypedSymbol<T> chan) {
        return ScoredIds.channelOrder(chan, Ordering.natural().nullsFirst());
    }

    public static <T> Ordering<ScoredId> channelOrder(final TypedSymbol<T> chan, final Comparator<? super T> order) {
        return new Ordering<ScoredId>(){

            public int compare(@Nullable ScoredId left, @Nullable ScoredId right) {
                Object v1 = null;
                Object v2 = null;
                if (left != null && left.hasChannel(chan)) {
                    v1 = left.channel(chan);
                }
                if (right != null && right.hasChannel(chan)) {
                    v2 = right.channel(chan);
                }
                return order.compare(v1, v2);
            }
        };
    }

    public static FastCollection<ScoredId> collectionFromVector(SparseVector vector) {
        return new VectorIdCollection(vector);
    }

    private static class VectorIdIter
    implements Iterator<ScoredId> {
        private final SparseVector vector;
        private Iterator<VectorEntry> entIter;
        private VectorEntryScoredId id;

        public VectorIdIter(SparseVector v) {
            this.vector = v;
            this.entIter = this.vector.fastIterator();
            this.id = new VectorEntryScoredId(this.vector);
        }

        @Override
        public boolean hasNext() {
            return this.entIter.hasNext();
        }

        @Override
        public ScoredId next() {
            this.id.setEntry(this.entIter.next());
            return this.id;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class VectorIdCollection
    extends CopyingFastCollection<ScoredId> {
        private final SparseVector vector;

        public VectorIdCollection(SparseVector v) {
            this.vector = v;
        }

        @Override
        protected ScoredId copy(ScoredId elt) {
            ScoredIdBuilder builder = new ScoredIdBuilder();
            builder.setId(elt.getId());
            builder.setScore(elt.getScore());
            for (Symbol symbol : elt.getUnboxedChannelSymbols()) {
                builder.addChannel(symbol, elt.channel(symbol));
            }
            for (TypedSymbol typedSymbol : elt.getChannelSymbols()) {
                builder.addChannel(typedSymbol, elt.channel(typedSymbol));
            }
            return builder.build();
        }

        @Override
        public int size() {
            return this.vector.size();
        }

        @Override
        public Iterator<ScoredId> fastIterator() {
            return new VectorIdIter(this.vector);
        }
    }

    private static final class ScoreOrder
    extends Ordering<ScoredId> {
        private ScoreOrder() {
        }

        public int compare(@Nullable ScoredId left, @Nullable ScoredId right) {
            return Doubles.compare((double)left.getScore(), (double)right.getScore());
        }
    }

    private static final class IdOrder
    extends Ordering<ScoredId> {
        private IdOrder() {
        }

        public int compare(@Nullable ScoredId left, @Nullable ScoredId right) {
            return Longs.compare((long)left.getId(), (long)right.getId());
        }
    }

    private static enum IdFunction implements Function<ScoredId, Long>
    {
        INSTANCE{

            @Nullable
            public Long apply(@Nullable ScoredId input) {
                if (input == null) {
                    return null;
                }
                return input.getId();
            }
        };

    }
}

