/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.scored;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.grouplens.lenskit.scored.AbstractScoredId;
import org.grouplens.lenskit.symbols.DoubleSymbolValue;
import org.grouplens.lenskit.symbols.Symbol;
import org.grouplens.lenskit.symbols.SymbolValue;
import org.grouplens.lenskit.symbols.TypedSymbol;
import org.grouplens.lenskit.vectors.SparseVector;
import org.grouplens.lenskit.vectors.VectorEntry;

class VectorEntryScoredId
extends AbstractScoredId {
    private final SparseVector vector;
    private VectorEntry ent;

    public VectorEntryScoredId(SparseVector v) {
        this.vector = v;
    }

    @Override
    public long getId() {
        return this.ent.getKey();
    }

    @Override
    public double getScore() {
        return this.ent.getValue();
    }

    @Override
    @Nonnull
    public Collection<SymbolValue<?>> getChannels() {
        return FluentIterable.from(this.vector.getChannelSymbols()).transform(new Function<TypedSymbol<?>, SymbolValue<?>>(){

            @Nullable
            public SymbolValue<?> apply(@Nullable TypedSymbol input) {
                assert (input != null);
                Object obj = VectorEntryScoredId.this.vector.getChannel(input).get(VectorEntryScoredId.this.ent.getKey());
                if (obj == null) {
                    return null;
                }
                return input.withValue(obj);
            }
        }).filter(Predicates.notNull()).toList();
    }

    @Override
    @Nonnull
    public Collection<DoubleSymbolValue> getUnboxedChannels() {
        return FluentIterable.from(this.vector.getChannelVectorSymbols()).transform((Function)new Function<Symbol, DoubleSymbolValue>(){

            @Nullable
            public DoubleSymbolValue apply(@Nullable Symbol input) {
                assert (input != null);
                if (VectorEntryScoredId.this.vector.getChannelVector(input).isSet(VectorEntryScoredId.this.ent)) {
                    return SymbolValue.of(input, VectorEntryScoredId.this.vector.getChannelVector(input).get(VectorEntryScoredId.this.ent));
                }
                return null;
            }
        }).filter(Predicates.notNull()).toList();
    }

    @Override
    @Nullable
    public <T> T getChannelValue(@Nonnull TypedSymbol<T> sym) {
        Long2ObjectMap<T> channel = this.vector.getChannel(sym);
        if (channel != null) {
            return (T)channel.get(this.ent.getKey());
        }
        return null;
    }

    @Override
    public double getUnboxedChannelValue(Symbol sym) {
        return this.vector.getChannelVector(sym).get(this.ent);
    }

    @Override
    public boolean hasUnboxedChannel(Symbol s) {
        return this.vector.hasChannelVector(s) && this.vector.getChannelVector(s).isSet(this.ent);
    }

    @Override
    public boolean hasChannel(TypedSymbol<?> s) {
        return this.vector.hasChannel(s) && this.vector.getChannel(s).containsKey(this.ent.getKey());
    }

    public void setEntry(VectorEntry e) {
        Preconditions.checkArgument((e.getVector() == this.vector ? 1 : 0) != 0, (Object)"entry must be associated with vector");
        this.ent = e;
    }
}

