/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.symbols;

import com.google.common.collect.Maps;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import org.grouplens.lenskit.symbols.TypedSymbol;

public final class Symbol
implements Serializable {
    private static final Map<String, Symbol> name2SymbolMap = Maps.newHashMap();
    private static final long serialVersionUID = 1L;
    private final String name;

    private Symbol(String name) {
        this.name = name;
    }

    private Object readResolve() throws ObjectStreamException {
        return Symbol.of(this.name);
    }

    public static synchronized Symbol of(String name) {
        if (name2SymbolMap.containsKey(name)) {
            return name2SymbolMap.get(name);
        }
        Symbol newSymbol = new Symbol(name);
        name2SymbolMap.put(name, newSymbol);
        return newSymbol;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("Symbol.of(%s)", this.getName());
    }

    public <T> TypedSymbol<T> withType(Class<T> type) {
        return TypedSymbol.of(type, this);
    }
}

