/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.symbols;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.grouplens.lenskit.symbols.DoubleSymbolValue;
import org.grouplens.lenskit.symbols.Symbol;
import org.grouplens.lenskit.symbols.TypedSymbol;
import org.grouplens.lenskit.symbols.TypedSymbolValue;

public abstract class SymbolValue<T> {
    public static <T> SymbolValue<T> of(TypedSymbol<T> sym, T val) {
        if (sym.getType().equals(Double.class)) {
            return new DoubleSymbolValue(sym, (Double)val);
        }
        return new TypedSymbolValue<T>(sym, val);
    }

    public static DoubleSymbolValue of(TypedSymbol<Double> sym, double val) {
        return new DoubleSymbolValue(sym, val);
    }

    public static DoubleSymbolValue of(Symbol sym, double val) {
        return SymbolValue.of(TypedSymbol.of(Double.class, sym), val);
    }

    SymbolValue() {
    }

    public abstract TypedSymbol<T> getSymbol();

    public Symbol getRawSymbol() {
        return this.getSymbol().getRawSymbol();
    }

    public abstract T getValue();

    public boolean equals(Object other) {
        if (other instanceof SymbolValue) {
            SymbolValue sv = (SymbolValue)other;
            if (this.getSymbol() != sv.getSymbol()) {
                return false;
            }
            assert (this.getSymbol().getClass().equals(sv.getSymbol().getClass()));
            return this.getValue().equals(sv.getValue());
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        return hcb.append(this.getSymbol()).append(this.getValue()).toHashCode();
    }

    public static Predicate<SymbolValue<?>> hasSymbol(final TypedSymbol<?> sym) {
        return new Predicate<SymbolValue<?>>(){

            public boolean apply(@Nullable SymbolValue<?> input) {
                return input != null && input.getSymbol() == sym;
            }
        };
    }

    public static Function<SymbolValue<?>, TypedSymbol<?>> extractSymbol() {
        return SymbolFunc.INSTANCE;
    }

    static enum SymbolFunc implements Function<SymbolValue<?>, TypedSymbol<?>>
    {
        INSTANCE{

            @Nullable
            public TypedSymbol<?> apply(@Nullable SymbolValue<?> input) {
                if (input == null) {
                    return null;
                }
                return input.getSymbol();
            }
        };

    }
}

