/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.symbols;

import com.google.common.collect.Maps;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.grouplens.lenskit.symbols.Symbol;
import org.grouplens.lenskit.symbols.SymbolValue;

public final class TypedSymbol<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Map<Pair<Class, Symbol>, TypedSymbol> symbolCache = Maps.newHashMap();
    private final Class<K> type;
    private final Symbol symbol;

    private TypedSymbol(Class<K> clazz, Symbol sym) {
        this.type = clazz;
        this.symbol = sym;
    }

    private Object readResolve() throws ObjectStreamException {
        return TypedSymbol.of(this.type, this.symbol);
    }

    public static <T> TypedSymbol<T> of(Class<T> type, String name) {
        return TypedSymbol.of(type, Symbol.of(name));
    }

    public static synchronized <T> TypedSymbol<T> of(Class<T> type, Symbol sym) {
        Pair key = type.isPrimitive() ? Pair.of((Object)ClassUtils.primitiveToWrapper(type), (Object)sym) : Pair.of(type, (Object)sym);
        TypedSymbol tsym = symbolCache.get(key);
        if (tsym == null) {
            if (type.isPrimitive()) {
                type = ClassUtils.primitiveToWrapper(type);
            }
            tsym = new TypedSymbol(type, sym);
            symbolCache.put((Pair<Class, Symbol>)key, tsym);
        }
        return tsym;
    }

    public String getName() {
        return this.symbol.getName();
    }

    public Class<K> getType() {
        return this.type;
    }

    public Symbol getRawSymbol() {
        return this.symbol;
    }

    @Deprecated
    public Symbol getSymbol() {
        return this.symbol;
    }

    public SymbolValue<K> withValue(K val) {
        return SymbolValue.of(this, val);
    }

    public String toString() {
        return String.format("TypedSymbol.of(%s,%s)", this.getType().getSimpleName(), this.getName());
    }
}

