/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.vectors;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.grouplens.lenskit.collections.LongKeyDomain;
import org.grouplens.lenskit.symbols.Symbol;
import org.grouplens.lenskit.symbols.TypedSymbol;
import org.grouplens.lenskit.vectors.MutableSparseVector;
import org.grouplens.lenskit.vectors.SparseVector;
import org.grouplens.lenskit.vectors.TypedSideChannel;

@Immutable
public final class ImmutableSparseVector
extends SparseVector
implements Serializable {
    private static final long serialVersionUID = -2L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final Map<Symbol, ImmutableSparseVector> channelVectors;
    private final Map<TypedSymbol<?>, Long2ObjectMap<?>> channels;
    private volatile transient Double norm = null;
    private volatile transient Double sum = null;
    private volatile transient Double mean = null;

    public static ImmutableSparseVector create(Map<Long, Double> data) {
        return MutableSparseVector.create(data).freeze();
    }

    @Deprecated
    public ImmutableSparseVector() {
        super(LongKeyDomain.empty());
        this.channelVectors = Collections.emptyMap();
        this.channels = Collections.emptyMap();
    }

    @Deprecated
    public ImmutableSparseVector(Long2DoubleMap ratings) {
        super(ratings);
        this.channelVectors = Collections.emptyMap();
        this.channels = Collections.emptyMap();
    }

    ImmutableSparseVector(LongKeyDomain ks, double[] vs, Map<Symbol, ImmutableSparseVector> chanVectors, Map<TypedSymbol<?>, Long2ObjectMap<?>> chans) {
        super(ks, vs);
        this.channelVectors = ImmutableMap.copyOf(chanVectors);
        this.channels = ImmutableMap.copyOf(chans);
    }

    @Override
    boolean isMutable() {
        return false;
    }

    @Override
    public ImmutableSparseVector immutable() {
        return this;
    }

    @Override
    public MutableSparseVector mutableCopy() {
        LongKeyDomain mks = this.keys.clone();
        double[] mvs = Arrays.copyOf(this.values, this.keys.domainSize());
        MutableSparseVector result = new MutableSparseVector(mks, mvs);
        for (Map.Entry<Symbol, ImmutableSparseVector> entry : this.channelVectors.entrySet()) {
            result.addVectorChannel(entry.getKey(), entry.getValue().mutableCopy());
        }
        for (Map.Entry<Serializable, ImmutableSparseVector> entry : this.channels.entrySet()) {
            TypedSymbol ts = (TypedSymbol)entry.getKey();
            if (!ts.getType().equals(Double.class)) {
                Long2ObjectMap val = (Long2ObjectMap)entry.getValue();
                assert (val instanceof TypedSideChannel);
                result.addChannel(ts, ((TypedSideChannel)val).mutableCopy());
                continue;
            }
            assert (result.hasChannel(ts));
        }
        return result;
    }

    @Override
    public boolean hasChannelVector(Symbol channelSymbol) {
        return this.channelVectors.containsKey(channelSymbol);
    }

    @Override
    public boolean hasChannel(TypedSymbol<?> channelSymbol) {
        return this.channels.containsKey(channelSymbol);
    }

    @Override
    public ImmutableSparseVector getChannelVector(Symbol channelSymbol) {
        return this.channelVectors.get(channelSymbol);
    }

    @Override
    public <K> Long2ObjectMap<K> getChannel(TypedSymbol<K> channelSymbol) {
        return this.channels.get(channelSymbol);
    }

    @Override
    @Deprecated
    public ImmutableSparseVector channel(Symbol channelSymbol) {
        ImmutableSparseVector v = this.getChannelVector(channelSymbol);
        if (v == null) {
            throw new IllegalArgumentException("unknown symbol " + channelSymbol);
        }
        return v;
    }

    @Override
    public Set<Symbol> getChannelVectorSymbols() {
        return this.channelVectors.keySet();
    }

    @Override
    public Set<TypedSymbol<?>> getChannelSymbols() {
        return this.channels.keySet();
    }

    @Override
    public double norm() {
        if (this.norm == null) {
            this.norm = super.norm();
        }
        return this.norm;
    }

    @Override
    public double sum() {
        if (this.sum == null) {
            this.sum = super.sum();
        }
        return this.sum;
    }

    @Override
    public double mean() {
        if (this.mean == null) {
            this.mean = super.mean();
        }
        return this.mean;
    }
}

