/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.vectors;

import java.util.Arrays;
import javax.annotation.concurrent.Immutable;
import org.grouplens.lenskit.vectors.Vec;

@Immutable
public final class ImmutableVec
extends Vec {
    private static final long serialVersionUID = 1L;
    private volatile transient Double sum;
    private volatile transient Double norm;

    private ImmutableVec(double[] v) {
        super(v);
    }

    static ImmutableVec wrap(double[] data) {
        return new ImmutableVec(data);
    }

    public static ImmutableVec create(double[] data) {
        return new ImmutableVec(Arrays.copyOf(data, data.length));
    }

    @Override
    public ImmutableVec immutable() {
        return this;
    }

    @Override
    public double sum() {
        if (this.sum == null) {
            this.sum = super.sum();
        }
        return this.sum;
    }

    @Override
    public double norm() {
        if (this.norm == null) {
            this.norm = super.norm();
        }
        return this.norm;
    }
}

