/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.vectors;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongComparators;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.grouplens.lenskit.collections.LongKeyDomain;
import org.grouplens.lenskit.collections.MoreArrays;
import org.grouplens.lenskit.symbols.Symbol;
import org.grouplens.lenskit.symbols.TypedSymbol;
import org.grouplens.lenskit.vectors.ImmutableSparseVector;
import org.grouplens.lenskit.vectors.MutableSparseVectorMap;
import org.grouplens.lenskit.vectors.MutableTypedSideChannel;
import org.grouplens.lenskit.vectors.SparseVector;
import org.grouplens.lenskit.vectors.SparseVectorMap;
import org.grouplens.lenskit.vectors.VectorEntry;

public final class MutableSparseVector
extends SparseVector
implements Serializable {
    private static final long serialVersionUID = 2L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="stored value is always serializable")
    private final Map<Symbol, MutableSparseVector> channelVectors;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="stored value is always serializable")
    private final Map<TypedSymbol<?>, Long2ObjectMap<?>> channels;

    public static MutableSparseVector create(Collection<Long> domain) {
        return new MutableSparseVector(LongKeyDomain.fromCollection(domain, false));
    }

    public static MutableSparseVector create(Collection<Long> domain, double value) {
        MutableSparseVector msv = MutableSparseVector.create(domain);
        msv.fill(value);
        return msv;
    }

    public static MutableSparseVector create(Map<Long, Double> content) {
        MutableSparseVector msv = MutableSparseVector.create(content.keySet());
        msv.keys.setAllActive(true);
        int len = msv.keys.domainSize();
        if (content instanceof Long2DoubleMap) {
            Long2DoubleMap fast = (Long2DoubleMap)content;
            for (int i = 0; i < len; ++i) {
                msv.values[i] = fast.get(msv.keys.getKey(i));
            }
        } else {
            for (int i = 0; i < len; ++i) {
                msv.values[i] = content.get(msv.keys.getKey(i));
            }
        }
        return msv;
    }

    @Deprecated
    public MutableSparseVector() {
        this(LongKeyDomain.empty());
    }

    MutableSparseVector(LongKeyDomain domain) {
        super(domain);
        this.channelVectors = new Reference2ObjectArrayMap();
        this.channels = new Reference2ObjectArrayMap();
    }

    @Deprecated
    public MutableSparseVector(Long2DoubleMap keyValueMap) {
        super(keyValueMap);
        this.channelVectors = new Reference2ObjectArrayMap();
        this.channels = new Reference2ObjectArrayMap();
    }

    @Deprecated
    public MutableSparseVector(Collection<Long> domain) {
        this(LongKeyDomain.fromCollection(domain, false));
    }

    @Deprecated
    public MutableSparseVector(LongSet keySet, double value) {
        this((Collection<Long>)keySet);
        this.keys.setAllActive(true);
        DoubleArrays.fill((double[])this.values, (int)0, (int)this.keys.domainSize(), (double)value);
    }

    MutableSparseVector(LongKeyDomain ks, double[] vs) {
        this(ks, vs, (Map<Symbol, MutableSparseVector>)new Reference2ObjectArrayMap(), (Map<TypedSymbol<?>, Long2ObjectMap<?>>)new Reference2ObjectArrayMap());
    }

    MutableSparseVector(LongKeyDomain ks, double[] vs, Map<Symbol, MutableSparseVector> cvs, Map<TypedSymbol<?>, Long2ObjectMap<?>> chs) {
        super(ks, vs);
        this.channelVectors = cvs;
        this.channels = chs;
    }

    @Override
    public LongSortedSet keySet() {
        return this.keys.modifiableActiveSetView();
    }

    public MutableSparseVector withDomain(LongSet keyDomain) {
        LongKeyDomain domain = LongKeyDomain.fromCollection((Collection<Long>)keyDomain, false);
        return this.withDomain(domain.unowned());
    }

    MutableSparseVector withDomain(LongKeyDomain domain) {
        MutableSparseVector msvNew = new MutableSparseVector(domain.clone());
        msvNew.set(this);
        for (Map.Entry<Symbol, MutableSparseVector> entry : this.channelVectors.entrySet()) {
            msvNew.addVectorChannel(entry.getKey(), entry.getValue().withDomain(domain));
        }
        for (Map.Entry<Serializable, MutableSparseVector> entry : this.channels.entrySet()) {
            TypedSymbol key = (TypedSymbol)entry.getKey();
            if (!key.getType().equals(Double.class)) {
                Long2ObjectMap chan = (Long2ObjectMap)entry.getValue();
                assert (chan instanceof MutableTypedSideChannel);
                msvNew.addChannel(key, ((MutableTypedSideChannel)chan).withDomain(domain));
                continue;
            }
            assert (msvNew.hasChannel(key));
            assert (entry.getValue() instanceof MutableSparseVectorMap);
        }
        return msvNew;
    }

    public MutableSparseVector shrinkDomain() {
        return this.withDomain(this.keys.compactCopy().unowned());
    }

    private void checkFrozen() {
        if (this.values == null) {
            throw new IllegalStateException("The mutable sparse vector is frozen");
        }
    }

    private double setAt(int index, double value) {
        assert (index >= 0);
        double v = this.keys.indexIsActive(index) ? this.values[index] : Double.NaN;
        this.values[index] = value;
        this.keys.setActive(index, true);
        return v;
    }

    public double set(long key, double value) {
        this.checkFrozen();
        int idx = this.keys.getIndex(key);
        if (idx < 0) {
            throw new IllegalArgumentException("Cannot 'set' key=" + key + " that is not in the key domain.");
        }
        return this.setAt(idx, value);
    }

    public double set(@Nonnull VectorEntry entry, double value) {
        Preconditions.checkNotNull((Object)entry, (Object)"vector entry");
        this.checkFrozen();
        SparseVector evec = entry.getVector();
        int eind = entry.getIndex();
        if (evec == null) {
            throw new IllegalArgumentException("entry is not associated with a vector");
        }
        if (!this.keys.isCompatibleWith(evec.keys)) {
            throw new IllegalArgumentException("entry does not have safe key domain");
        }
        if (eind < 0) {
            throw new IllegalArgumentException("Cannot 'set' a key with a negative index.");
        }
        assert (this.keys.getKey(eind) == entry.getKey());
        if (evec == this) {
            entry.setValue(value);
        }
        return this.setAt(eind, value);
    }

    public void fill(double value) {
        this.checkFrozen();
        DoubleArrays.fill((double[])this.values, (int)0, (int)this.keys.domainSize(), (double)value);
        this.keys.setAllActive(true);
    }

    @Deprecated
    public void clear(long key) {
        this.unset(key);
    }

    @Deprecated
    public void clear(VectorEntry e) {
        this.unset(e);
    }

    public void unset(long key) {
        this.checkFrozen();
        int idx = this.keys.getIndex(key);
        if (idx < 0) {
            throw new IllegalArgumentException("unset should only be used on keys that are in the key domain");
        }
        this.keys.setActive(idx, false);
    }

    public void unset(@Nonnull VectorEntry entry) {
        Preconditions.checkNotNull((Object)entry, (Object)"vector entry");
        this.checkFrozen();
        SparseVector evec = entry.getVector();
        int eind = entry.getIndex();
        if (evec == null) {
            throw new IllegalArgumentException("entry is not associated with a vector");
        }
        if (!this.keys.isCompatibleWith(evec.keys)) {
            throw new IllegalArgumentException("entry does not have safe key domain");
        }
        if (eind < 0) {
            throw new IllegalArgumentException("Cannot 'set' a key with a negative index.");
        }
        assert (this.keys.getKey(eind) == entry.getKey());
        this.keys.setActive(eind, false);
    }

    public void clear() {
        this.keys.setAllActive(false);
    }

    public double add(long key, double value) {
        this.checkFrozen();
        int idx = this.keys.getIndexIfActive(key);
        if (idx >= 0) {
            int n = idx;
            this.values[n] = this.values[n] + value;
            return this.values[idx];
        }
        throw new IllegalArgumentException("invalid key " + key);
    }

    public void add(double value) {
        this.checkFrozen();
        int end = this.keys.domainSize();
        int i = 0;
        while (i < end) {
            int n = i++;
            this.values[n] = this.values[n] + value;
        }
    }

    public void subtract(SparseVector other) {
        VectorEntry e2;
        this.checkFrozen();
        Iterator<VectorEntry> i1 = this.fastIterator();
        Iterator<VectorEntry> i2 = other.fastIterator();
        VectorEntry e1 = i1.hasNext() ? i1.next() : null;
        VectorEntry vectorEntry = e2 = i2.hasNext() ? i2.next() : null;
        while (e1 != null && e2 != null) {
            long k2;
            long k1 = e1.getKey();
            if (k1 < (k2 = e2.getKey())) {
                e1 = i1.hasNext() ? i1.next() : null;
                continue;
            }
            if (k2 < k1) {
                e2 = i2.hasNext() ? i2.next() : null;
                continue;
            }
            this.set(e1, e1.getValue() - e2.getValue());
            e1 = i1.hasNext() ? i1.next() : null;
            e2 = i2.hasNext() ? i2.next() : null;
        }
    }

    public void add(SparseVector other) {
        VectorEntry e2;
        this.checkFrozen();
        Iterator<VectorEntry> i1 = this.fastIterator();
        Iterator<VectorEntry> i2 = other.fastIterator();
        VectorEntry e1 = i1.hasNext() ? i1.next() : null;
        VectorEntry vectorEntry = e2 = i2.hasNext() ? i2.next() : null;
        while (e1 != null && e2 != null) {
            long k2;
            long k1 = e1.getKey();
            if (k1 < (k2 = e2.getKey())) {
                e1 = i1.hasNext() ? i1.next() : null;
                continue;
            }
            if (k2 < k1) {
                e2 = i2.hasNext() ? i2.next() : null;
                continue;
            }
            this.set(e1, e1.getValue() + e2.getValue());
            e1 = i1.hasNext() ? i1.next() : null;
            e2 = i2.hasNext() ? i2.next() : null;
        }
    }

    public void set(SparseVector other) {
        VectorEntry e2;
        this.checkFrozen();
        Iterator<VectorEntry> i1 = this.fastIterator(VectorEntry.State.EITHER);
        Iterator<VectorEntry> i2 = other.fastIterator();
        VectorEntry e1 = i1.hasNext() ? i1.next() : null;
        VectorEntry vectorEntry = e2 = i2.hasNext() ? i2.next() : null;
        while (e1 != null && e2 != null) {
            long k2;
            long k1 = e1.getKey();
            if (k1 < (k2 = e2.getKey())) {
                e1 = i1.hasNext() ? i1.next() : null;
                continue;
            }
            if (k2 < k1) {
                e2 = i2.hasNext() ? i2.next() : null;
                continue;
            }
            this.setAt(e1.getIndex(), e2.getValue());
            e1 = i1.hasNext() ? i1.next() : null;
            e2 = i2.hasNext() ? i2.next() : null;
        }
    }

    public void multiply(double s) {
        this.checkFrozen();
        int end = this.keys.domainSize();
        int i = 0;
        while (i < end) {
            int n = i++;
            this.values[n] = this.values[n] * s;
        }
    }

    public void multiply(SparseVector other) {
        VectorEntry e2;
        this.checkFrozen();
        Iterator<VectorEntry> i1 = this.fastIterator();
        Iterator<VectorEntry> i2 = other.fastIterator();
        VectorEntry e1 = i1.hasNext() ? i1.next() : null;
        VectorEntry vectorEntry = e2 = i2.hasNext() ? i2.next() : null;
        while (e1 != null && e2 != null) {
            long k2;
            long k1 = e1.getKey();
            if (k1 < (k2 = e2.getKey())) {
                e1 = i1.hasNext() ? i1.next() : null;
                continue;
            }
            if (k2 < k1) {
                e2 = i2.hasNext() ? i2.next() : null;
                continue;
            }
            this.set(e1, e1.getValue() * e2.getValue());
            e1 = i1.hasNext() ? i1.next() : null;
            e2 = i2.hasNext() ? i2.next() : null;
        }
    }

    @Deprecated
    public void scale(double s) {
        this.multiply(s);
    }

    public MutableSparseVector copy() {
        return this.mutableCopy();
    }

    @Override
    public MutableSparseVector mutableCopy() {
        Serializable key;
        this.checkFrozen();
        LongKeyDomain mks = this.keys.clone();
        double[] mvs = Arrays.copyOf(this.values, this.keys.domainSize());
        Reference2ObjectArrayMap newChanVectors = new Reference2ObjectArrayMap();
        Reference2ObjectArrayMap newChannels = new Reference2ObjectArrayMap();
        for (Map.Entry<Symbol, MutableSparseVector> entry : this.channelVectors.entrySet()) {
            key = entry.getKey();
            MutableSparseVector msv = entry.getValue().copy();
            newChanVectors.put(key, msv);
            newChannels.put(((Symbol)key).withType(Double.class), new MutableSparseVectorMap(msv));
        }
        for (Map.Entry<Serializable, MutableSparseVector> entry : this.channels.entrySet()) {
            key = (TypedSymbol)entry.getKey();
            if (!((TypedSymbol)key).getType().equals(Double.class)) {
                Long2ObjectMap chan = (Long2ObjectMap)entry.getValue();
                assert (chan instanceof MutableTypedSideChannel);
                newChannels.put(key, ((MutableTypedSideChannel)chan).mutableCopy());
                continue;
            }
            assert (newChannels.containsKey(key));
            assert (entry.getValue() instanceof MutableSparseVectorMap);
        }
        return new MutableSparseVector(mks, mvs, (Map<Symbol, MutableSparseVector>)newChanVectors, (Map<TypedSymbol<?>, Long2ObjectMap<?>>)newChannels);
    }

    @Override
    public ImmutableSparseVector immutable() {
        return this.immutable(false);
    }

    public ImmutableSparseVector freeze() {
        return this.immutable(true);
    }

    ImmutableSparseVector immutable(boolean freeze) {
        this.checkFrozen();
        return this.immutable(freeze, this.keys.compactCopy().unowned());
    }

    private ImmutableSparseVector immutable(boolean freeze, LongKeyDomain keyDomain) {
        Serializable key;
        double[] nvs;
        LongKeyDomain newDomain = keyDomain.clone();
        if (newDomain.isCompatibleWith(this.keys)) {
            nvs = freeze ? this.values : Arrays.copyOf(this.values, newDomain.domainSize());
            newDomain.setActive(this.keys.getActiveMask());
        } else {
            nvs = new double[newDomain.domainSize()];
            int i = 0;
            int j = 0;
            int end = this.keys.domainSize();
            while (i < nvs.length && j < end) {
                long kj;
                long l = newDomain.getKey(i);
                if (l == (kj = this.keys.getKey(j))) {
                    nvs[i] = this.values[j];
                    newDomain.setActive(i, this.keys.indexIsActive(j));
                    ++i;
                    ++j;
                    continue;
                }
                if (kj < l) {
                    ++j;
                    continue;
                }
                throw new AssertionError((Object)"new domain not subset of old domain");
            }
        }
        Reference2ObjectArrayMap newChannelVectors = new Reference2ObjectArrayMap(this.channelVectors.size());
        Reference2ObjectArrayMap newChannels = new Reference2ObjectArrayMap();
        for (Map.Entry<Symbol, MutableSparseVector> entry : this.channelVectors.entrySet()) {
            key = entry.getKey();
            ImmutableSparseVector chan = entry.getValue().immutable(freeze, newDomain);
            newChannelVectors.put(key, chan);
            newChannels.put(((Symbol)key).withType(Double.class), new SparseVectorMap(chan));
        }
        for (Map.Entry<Serializable, MutableSparseVector> entry : this.channels.entrySet()) {
            key = (TypedSymbol)entry.getKey();
            if (!((TypedSymbol)key).getType().equals(Double.class)) {
                Long2ObjectMap chan = (Long2ObjectMap)entry.getValue();
                assert (chan instanceof MutableTypedSideChannel);
                newChannels.put(key, ((MutableTypedSideChannel)chan).immutable(newDomain, freeze));
                continue;
            }
            assert (newChannels.containsKey(key));
            assert (entry.getValue() instanceof MutableSparseVectorMap);
        }
        ImmutableSparseVector isv = new ImmutableSparseVector(newDomain, nvs, (Map<Symbol, ImmutableSparseVector>)newChannelVectors, (Map<TypedSymbol<?>, Long2ObjectMap<?>>)newChannels);
        if (freeze) {
            this.values = null;
        }
        return isv;
    }

    public static MutableSparseVector wrap(long[] keys, double[] values) {
        return MutableSparseVector.wrap(keys, values, keys.length);
    }

    public static MutableSparseVector wrap(long[] keys, double[] values, int size) {
        if (values.length < size) {
            throw new IllegalArgumentException("value array too short");
        }
        if (keys.length < size) {
            throw new IllegalArgumentException("key array too short");
        }
        if (!MoreArrays.isSorted(keys, 0, size)) {
            throw new IllegalArgumentException("item array not sorted");
        }
        LongKeyDomain keySet = LongKeyDomain.wrap(keys, size, true);
        return new MutableSparseVector(keySet, values);
    }

    public static MutableSparseVector wrap(LongArrayList keyList, DoubleArrayList valueList) {
        long[] keys = keyList.elements();
        double[] values = valueList.elements();
        return MutableSparseVector.wrap(keys, values, keyList.size());
    }

    public static MutableSparseVector create(long ... keys) {
        return new MutableSparseVector((Collection<Long>)new LongOpenHashSet(keys));
    }

    public static MutableSparseVector wrapUnsorted(long[] keys, double[] values) {
        IdComparator comparator = new IdComparator(keys);
        ParallelSwapper swapper = new ParallelSwapper(keys, values);
        it.unimi.dsi.fastutil.Arrays.quickSort((int)0, (int)keys.length, (IntComparator)comparator, (Swapper)swapper);
        return MutableSparseVector.wrap(keys, values);
    }

    public SparseVector removeChannelVector(Symbol channelSymbol) {
        this.checkFrozen();
        if (this.hasChannelVector(channelSymbol)) {
            SparseVector retval = this.channelVectors.remove(channelSymbol);
            this.channels.remove(channelSymbol.withType(Double.class));
            return retval;
        }
        throw new IllegalArgumentException("No such channel " + channelSymbol.getName());
    }

    public <K> Long2ObjectMap<K> removeChannel(TypedSymbol<K> channelSymbol) {
        this.checkFrozen();
        if (this.hasChannel(channelSymbol)) {
            Long2ObjectMap<?> retval = this.channels.remove(channelSymbol);
            if (channelSymbol.getType().equals(Double.class)) {
                this.channelVectors.remove(channelSymbol.getRawSymbol());
            }
            return retval;
        }
        throw new IllegalArgumentException("No such channel " + channelSymbol.getName() + " with type " + channelSymbol.getType().getSimpleName());
    }

    public void removeAllChannels() {
        this.checkFrozen();
        this.channelVectors.clear();
        this.channels.clear();
    }

    public MutableSparseVector addChannelVector(Symbol channelSymbol) {
        this.checkFrozen();
        if (this.hasChannelVector(channelSymbol)) {
            throw new IllegalArgumentException("Channel " + channelSymbol.getName() + " already exists");
        }
        MutableSparseVector theChannel = new MutableSparseVector(this.keys.inactiveCopy());
        this.channelVectors.put(channelSymbol, theChannel);
        assert (!this.channels.containsKey(channelSymbol.withType(Double.class)));
        this.channels.put(channelSymbol.withType(Double.class), (Long2ObjectMap<?>)new MutableSparseVectorMap(theChannel));
        return theChannel;
    }

    @Deprecated
    public MutableSparseVector addChannel(Symbol channelSymbol) {
        return this.addChannelVector(channelSymbol);
    }

    public <K> Long2ObjectMap<K> addChannel(TypedSymbol<K> channelSymbol) {
        this.checkFrozen();
        if (this.hasChannel(channelSymbol)) {
            throw new IllegalArgumentException("Channel " + channelSymbol.getName() + " with type " + channelSymbol.getType().getSimpleName() + " already exists");
        }
        if (channelSymbol.getType().equals(Double.class)) {
            this.addChannelVector(channelSymbol.getRawSymbol());
            return this.channels.get(channelSymbol);
        }
        MutableTypedSideChannel theChannel = new MutableTypedSideChannel(this.keys.inactiveCopy());
        this.channels.put(channelSymbol, (Long2ObjectMap<?>)theChannel);
        return theChannel;
    }

    public MutableSparseVector getOrAddChannelVector(Symbol channelSymbol) {
        MutableSparseVector chan = this.getChannelVector(channelSymbol);
        if (chan == null) {
            chan = this.addChannelVector(channelSymbol);
        }
        return chan;
    }

    @Deprecated
    public MutableSparseVector alwaysAddChannel(Symbol channelSymbol) {
        return this.getOrAddChannelVector(channelSymbol);
    }

    public <K> Long2ObjectMap<K> getOrAddChannel(TypedSymbol<K> channelSymbol) {
        Long2ObjectMap<K> chan = this.getChannel(channelSymbol);
        if (chan == null) {
            chan = this.addChannel(channelSymbol);
        }
        return chan;
    }

    @Deprecated
    public <K> Long2ObjectMap<K> alwaysAddChannel(TypedSymbol<K> channelSymbol) {
        return this.getOrAddChannel(channelSymbol);
    }

    void addVectorChannel(Symbol key, MutableSparseVector vectorEntries) {
        Preconditions.checkArgument((boolean)this.keys.isCompatibleWith(vectorEntries.keys), (Object)"vector has incompatible key domain");
        this.channelVectors.put(key, vectorEntries);
        this.channels.put(key.withType(Double.class), (Long2ObjectMap<?>)new MutableSparseVectorMap(vectorEntries));
    }

    <T> void addChannel(TypedSymbol<T> sym, MutableTypedSideChannel<T> chan) {
        Preconditions.checkArgument((boolean)this.keys.isCompatibleWith(chan.keys), (Object)"vector has incompatible key domain");
        Preconditions.checkArgument((!sym.getType().equals(Double.class) ? 1 : 0) != 0, (Object)"cannot add double channel like this");
        this.channels.put(sym, (Long2ObjectMap<?>)chan);
    }

    @Override
    public boolean hasChannelVector(Symbol channelSymbol) {
        return this.channelVectors.containsKey(channelSymbol);
    }

    @Override
    public boolean hasChannel(TypedSymbol<?> channelSymbol) {
        return this.channels.containsKey(channelSymbol);
    }

    @Override
    public MutableSparseVector getChannelVector(Symbol channelSymbol) {
        this.checkFrozen();
        return this.channelVectors.get(channelSymbol);
    }

    @Override
    @Deprecated
    public SparseVector channel(Symbol channelSymbol) {
        MutableSparseVector v = this.getChannelVector(channelSymbol);
        if (v != null) {
            return v;
        }
        throw new IllegalArgumentException("no such channel " + channelSymbol);
    }

    @Override
    public <K> Long2ObjectMap<K> getChannel(TypedSymbol<K> channelSymbol) {
        this.checkFrozen();
        return this.channels.get(channelSymbol);
    }

    @Override
    public Set<Symbol> getChannelVectorSymbols() {
        return Collections.unmodifiableSet(this.channelVectors.keySet());
    }

    @Override
    public Set<TypedSymbol<?>> getChannelSymbols() {
        return Collections.unmodifiableSet(this.channels.keySet());
    }

    private static class ParallelSwapper
    implements Swapper {
        private long[] keys;
        private double[] values;

        public ParallelSwapper(long[] keys, double[] values) {
            this.keys = keys;
            this.values = values;
        }

        public void swap(int i, int i2) {
            long lTemp = this.keys[i];
            this.keys[i] = this.keys[i2];
            this.keys[i2] = lTemp;
            double dTemp = this.values[i];
            this.values[i] = this.values[i2];
            this.values[i2] = dTemp;
        }
    }

    private static class IdComparator
    extends AbstractIntComparator {
        private long[] keys;

        public IdComparator(long[] keys) {
            this.keys = keys;
        }

        public int compare(int i, int i2) {
            return LongComparators.NATURAL_COMPARATOR.compare(this.keys[i], this.keys[i2]);
        }
    }
}

