/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.vectors;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.Arrays;
import org.grouplens.lenskit.collections.LongKeyDomain;
import org.grouplens.lenskit.vectors.TypedSideChannel;

class MutableTypedSideChannel<V>
extends TypedSideChannel<V> {
    private static final long serialVersionUID = 1L;

    MutableTypedSideChannel(LongKeyDomain ks, V[] vs, V dft) {
        super(ks, vs, dft);
    }

    MutableTypedSideChannel(LongKeyDomain ks, V[] vs) {
        super(ks, vs);
    }

    MutableTypedSideChannel(LongKeyDomain ks) {
        super(ks);
    }

    protected void checkMutable() {
        if (this.frozen) {
            throw new IllegalStateException("side channel is frozen");
        }
    }

    @Override
    public TypedSideChannel<V> immutable() {
        return new TypedSideChannel<Object>(this.keys.clone(), Arrays.copyOf(this.values, this.keys.domainSize()), this.defaultReturnValue());
    }

    public TypedSideChannel<V> immutable(LongKeyDomain domain, boolean freeze) {
        LongKeyDomain nks = domain.clone();
        V[] nvs = this.adjustStorage(nks, freeze);
        this.frozen |= freeze;
        return new TypedSideChannel<Object>(nks, nvs, this.defaultReturnValue());
    }

    public MutableTypedSideChannel<V> withDomain(LongKeyDomain domain) {
        LongKeyDomain nks = domain.clone();
        V[] nvs = this.adjustStorage(nks, false);
        MutableTypedSideChannel<Object> copy = new MutableTypedSideChannel<Object>(nks, nvs, this.defaultReturnValue());
        copy.defaultReturnValue(this.defaultReturnValue());
        return copy;
    }

    private V[] adjustStorage(LongKeyDomain domain, boolean reuseIfPossible) {
        Object[] nvs;
        if (domain.isCompatibleWith(this.keys)) {
            nvs = reuseIfPossible ? this.values : Arrays.copyOf(this.values, domain.domainSize());
            domain.setActive(this.keys.getActiveMask());
        } else {
            nvs = new Object[domain.domainSize()];
            int i = 0;
            int j = 0;
            int end = this.keys.domainSize();
            while (i < nvs.length && j < end) {
                long kj;
                long ki = domain.getKey(i);
                if (ki == (kj = this.keys.getKey(j))) {
                    nvs[i] = this.values[j];
                    domain.setActive(i, this.keys.indexIsActive(j));
                    ++i;
                    ++j;
                    continue;
                }
                if (kj < ki) {
                    ++j;
                    continue;
                }
                domain.setActive(i, false);
                ++i;
            }
        }
        return nvs;
    }

    public void clear() {
        this.checkMutable();
        this.keys.setAllActive(false);
        ObjectArrays.fill((Object[])this.values, null);
    }

    public V put(long key, V value) {
        Preconditions.checkNotNull(value, (Object)"channel values cannot be null");
        this.checkMutable();
        int idx = this.keys.getIndex(key);
        if (idx >= 0) {
            Object retval = this.keys.indexIsActive(idx) ? this.values[idx] : this.defaultReturnValue();
            this.values[idx] = value;
            this.keys.setActive(idx, true);
            return (V)retval;
        }
        throw new IllegalArgumentException("key " + key + " not in key domain");
    }

    public V remove(long key) {
        this.checkMutable();
        int idx = this.keys.getIndex(key);
        Object retval = this.defaultReturnValue();
        if (idx >= 0) {
            if (this.keys.indexIsActive(idx)) {
                retval = this.values[idx];
            }
            this.keys.setActive(idx, false);
            this.values[idx] = null;
        }
        return (V)retval;
    }

    @Override
    public void defaultReturnValue(V rv) {
        this.checkMutable();
        this.defRetValue = rv;
    }

    TypedSideChannel<V> partialFreeze() {
        this.frozen = true;
        return this;
    }
}

