/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.vectors;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import org.grouplens.lenskit.vectors.Vec;

public final class MutableVec
extends Vec {
    private static final long serialVersionUID = 1L;

    private MutableVec(double[] v) {
        super(v);
    }

    public static MutableVec create(int dim) {
        return new MutableVec(new double[dim]);
    }

    public static MutableVec wrap(double[] data) {
        return new MutableVec(data);
    }

    public double set(int i, double v) {
        Preconditions.checkElementIndex((int)i, (int)this.size());
        double old = this.data[i];
        this.data[i] = v;
        return old;
    }

    public double add(int i, double v) {
        Preconditions.checkElementIndex((int)i, (int)this.size());
        double old = this.data[i];
        this.data[i] = v + old;
        return old;
    }

    public void fill(double v) {
        DoubleArrays.fill((double[])this.data, (double)v);
    }

    public void set(Vec v) {
        Preconditions.checkArgument((v.size() == this.size() ? 1 : 0) != 0, (Object)"incompatible vector dimensions");
        System.arraycopy(v.data, 0, this.data, 0, v.size());
    }

    public void set(double[] v) {
        Preconditions.checkArgument((v.length == this.size() ? 1 : 0) != 0, (Object)"incompatible vector dimensions");
        System.arraycopy(v, 0, this.data, 0, v.length);
    }

    public void add(Vec v) {
        Preconditions.checkArgument((v.size() == this.size() ? 1 : 0) != 0, (Object)"incompatible vector dimensions");
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            int n = i;
            this.data[n] = this.data[n] + v.data[i];
        }
    }

    public void scale(double s) {
        int sz = this.size();
        int i = 0;
        while (i < sz) {
            int n = i++;
            this.data[n] = this.data[n] * s;
        }
    }
}

