/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.vectors;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Longs;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleCollection;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.longs.AbstractLongComparator;
import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.grouplens.lenskit.collections.LongKeyDomain;
import org.grouplens.lenskit.symbols.Symbol;
import org.grouplens.lenskit.symbols.TypedSymbol;
import org.grouplens.lenskit.vectors.ImmutableSparseVector;
import org.grouplens.lenskit.vectors.MutableSparseVector;
import org.grouplens.lenskit.vectors.VectorEntry;

public abstract class SparseVector
implements Iterable<VectorEntry>,
Serializable {
    private static final long serialVersionUID = 2L;
    final LongKeyDomain keys;
    double[] values;

    SparseVector(LongKeyDomain ks, double[] vs) {
        assert (vs.length >= ks.domainSize());
        this.keys = ks;
        this.keys.acquire();
        this.values = vs;
    }

    SparseVector(LongKeyDomain ks) {
        this(ks, new double[ks.domainSize()]);
        ks.setAllActive(false);
    }

    SparseVector(Long2DoubleMap keyValueMap) {
        this.keys = LongKeyDomain.fromCollection((Collection<Long>)keyValueMap.keySet(), true);
        int len = this.keys.domainSize();
        this.values = new double[len];
        for (int i = 0; i < len; ++i) {
            this.values[i] = keyValueMap.get(this.keys.getKey(i));
        }
    }

    public boolean containsKey(long key) {
        return this.keys.keyIsActive(key);
    }

    public double get(long key) {
        int idx = this.keys.getIndexIfActive(key);
        if (idx >= 0) {
            return this.values[idx];
        }
        throw new IllegalArgumentException("Key " + key + " is not in the key set");
    }

    public double get(long key, double dft) {
        int idx = this.keys.getIndexIfActive(key);
        if (idx >= 0) {
            return this.values[idx];
        }
        return dft;
    }

    public double get(VectorEntry entry) {
        SparseVector evec = entry.getVector();
        int eind = entry.getIndex();
        if (evec == null) {
            throw new IllegalArgumentException("entry is not associated with a vector");
        }
        if (!evec.keys.isCompatibleWith(this.keys)) {
            throw new IllegalArgumentException("entry does not have safe key domain");
        }
        assert (entry.getKey() == this.keys.getKey(eind));
        if (this.keys.indexIsActive(eind)) {
            return this.values[eind];
        }
        throw new IllegalArgumentException("Key " + entry.getKey() + " is not set");
    }

    public boolean isSet(VectorEntry entry) {
        SparseVector evec = entry.getVector();
        int eind = entry.getIndex();
        if (evec == null) {
            throw new IllegalArgumentException("entry is not associated with a vector");
        }
        if (!this.keys.isCompatibleWith(evec.keys)) {
            throw new IllegalArgumentException("entry does not have safe key domain");
        }
        assert (entry.getKey() == this.keys.getKey(eind));
        return this.keys.indexIsActive(eind);
    }

    public Iterator<VectorEntry> fastIterator() {
        return this.fastIterator(VectorEntry.State.SET);
    }

    boolean isMutable() {
        return true;
    }

    public Iterator<VectorEntry> fastIterator(VectorEntry.State state) {
        IntBidirectionalIterator iter;
        switch (state) {
            case SET: {
                iter = this.keys.activeIndexIterator(this.isMutable());
                break;
            }
            case UNSET: {
                iter = this.keys.clone().invert().activeIndexIterator(false);
                break;
            }
            case EITHER: {
                iter = IntIterators.fromTo((int)0, (int)this.keys.domainSize());
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid entry state");
            }
        }
        return new FastIterImpl((IntIterator)iter, state);
    }

    public Iterable<VectorEntry> fast() {
        return this.fast(VectorEntry.State.SET);
    }

    public Iterable<VectorEntry> fast(final VectorEntry.State state) {
        return new Iterable<VectorEntry>(){

            @Override
            public Iterator<VectorEntry> iterator() {
                return SparseVector.this.fastIterator(state);
            }
        };
    }

    @Override
    public Iterator<VectorEntry> iterator() {
        return new IterImpl();
    }

    public LongSortedSet keyDomain() {
        return this.keys.domain();
    }

    public LongSortedSet keySet() {
        return this.keys.activeSetView();
    }

    public LongSortedSet unsetKeySet() {
        return this.keys.clone().invert().activeSetView();
    }

    public LongArrayList keysByValue() {
        return this.keysByValue(false);
    }

    public DoubleCollection values() {
        DoubleArrayList lst = new DoubleArrayList(this.size());
        IntBidirectionalIterator iter = this.keys.activeIndexIterator(false);
        while (iter.hasNext()) {
            int idx = iter.nextInt();
            lst.add(this.values[idx]);
        }
        return lst;
    }

    public LongArrayList keysByValue(boolean decreasing) {
        long[] skeys = this.keySet().toLongArray();
        AbstractLongComparator cmp = decreasing ? new AbstractLongComparator(){

            public int compare(long k1, long k2) {
                int c = Double.compare(SparseVector.this.get(k2), SparseVector.this.get(k1));
                if (c != 0) {
                    return c;
                }
                return Longs.compare((long)k1, (long)k2);
            }
        } : new AbstractLongComparator(){

            public int compare(long k1, long k2) {
                int c = Double.compare(SparseVector.this.get(k1), SparseVector.this.get(k2));
                if (c != 0) {
                    return c;
                }
                return Longs.compare((long)k1, (long)k2);
            }
        };
        LongArrays.quickSort((long[])skeys, (LongComparator)cmp);
        return LongArrayList.wrap((long[])skeys);
    }

    public int size() {
        return this.keys.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public double norm() {
        double ssq = 0.0;
        DoubleIterator iter = this.values().iterator();
        while (iter.hasNext()) {
            double v = iter.nextDouble();
            ssq += v * v;
        }
        return Math.sqrt(ssq);
    }

    public double sum() {
        double result = 0.0;
        DoubleIterator iter = this.values().iterator();
        while (iter.hasNext()) {
            result += iter.nextDouble();
        }
        return result;
    }

    public double mean() {
        int sz = this.size();
        return sz > 0 ? this.sum() / (double)sz : 0.0;
    }

    public double dot(SparseVector o) {
        VectorEntry e2;
        double dot = 0.0;
        Iterator<VectorEntry> i1 = this.fastIterator();
        Iterator<VectorEntry> i2 = o.fastIterator();
        VectorEntry e1 = i1.hasNext() ? i1.next() : null;
        VectorEntry vectorEntry = e2 = i2.hasNext() ? i2.next() : null;
        while (e1 != null && e2 != null) {
            long k2;
            long k1 = e1.getKey();
            if (k1 < (k2 = e2.getKey())) {
                e1 = i1.hasNext() ? i1.next() : null;
                continue;
            }
            if (k2 < k1) {
                e2 = i2.hasNext() ? i2.next() : null;
                continue;
            }
            dot += e1.getValue() * e2.getValue();
            e1 = i1.hasNext() ? i1.next() : null;
            e2 = i2.hasNext() ? i2.next() : null;
        }
        return dot;
    }

    public int countCommonKeys(SparseVector o) {
        VectorEntry e2;
        int count = 0;
        Iterator<VectorEntry> i1 = this.fastIterator();
        Iterator<VectorEntry> i2 = o.fastIterator();
        VectorEntry e1 = i1.hasNext() ? i1.next() : null;
        VectorEntry vectorEntry = e2 = i2.hasNext() ? i2.next() : null;
        while (e1 != null && e2 != null) {
            long k2;
            long k1 = e1.getKey();
            if (k1 < (k2 = e2.getKey())) {
                e1 = i1.hasNext() ? i1.next() : null;
                continue;
            }
            if (k2 < k1) {
                e2 = i2.hasNext() ? i2.next() : null;
                continue;
            }
            ++count;
            e1 = i1.hasNext() ? i1.next() : null;
            e2 = i2.hasNext() ? i2.next() : null;
        }
        return count;
    }

    public String toString() {
        Function<VectorEntry, String> label = new Function<VectorEntry, String>(){

            public String apply(VectorEntry e) {
                return String.format("%d: %.3f", e.getKey(), e.getValue());
            }
        };
        return "{" + StringUtils.join((Iterator)Iterators.transform(this.fastIterator(), (Function)label), (String)", ") + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SparseVector) {
            int osz;
            SparseVector vo = (SparseVector)o;
            int sz = this.size();
            if (sz != (osz = vo.size())) {
                return false;
            }
            if (!this.keySet().equals(vo.keySet())) {
                return false;
            }
            return this.values().equals(vo.values());
        }
        return false;
    }

    public int hashCode() {
        return this.keySet().hashCode() ^ this.values().hashCode();
    }

    public abstract ImmutableSparseVector immutable();

    public abstract MutableSparseVector mutableCopy();

    public abstract boolean hasChannelVector(Symbol var1);

    @Deprecated
    public boolean hasChannel(Symbol sym) {
        return this.hasChannelVector(sym);
    }

    public abstract boolean hasChannel(TypedSymbol<?> var1);

    public abstract SparseVector getChannelVector(Symbol var1);

    public abstract <K> Long2ObjectMap<K> getChannel(TypedSymbol<K> var1);

    @Deprecated
    public abstract SparseVector channel(Symbol var1);

    @Nonnull
    @Deprecated
    public <K> Long2ObjectMap<K> channel(TypedSymbol<K> channelSymbol) {
        Long2ObjectMap<K> chan = this.getChannel(channelSymbol);
        if (chan == null) {
            throw new IllegalArgumentException("no such channel " + channelSymbol);
        }
        return chan;
    }

    public abstract Set<Symbol> getChannelVectorSymbols();

    public abstract Set<TypedSymbol<?>> getChannelSymbols();

    public static ImmutableSparseVector empty() {
        return new ImmutableSparseVector();
    }

    private class FastIterImpl
    implements Iterator<VectorEntry> {
        private final VectorEntry.State state;
        private VectorEntry entry;
        private IntIterator iter;

        public FastIterImpl(IntIterator positions, VectorEntry.State st) {
            this.entry = new VectorEntry(SparseVector.this, -1, 0L, 0.0, false);
            this.iter = positions;
            this.state = st;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        @Nonnull
        public VectorEntry next() {
            int pos = this.iter.nextInt();
            boolean isSet = this.state == VectorEntry.State.SET || SparseVector.this.keys.indexIsActive(pos);
            double v = isSet ? SparseVector.this.values[pos] : Double.NaN;
            this.entry.set(pos, SparseVector.this.keys.getKey(pos), v, isSet);
            return this.entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class IterImpl
    implements Iterator<VectorEntry> {
        private IntIterator iter;

        private IterImpl() {
            this.iter = SparseVector.this.keys.activeIndexIterator(SparseVector.this.isMutable());
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        @Nonnull
        public VectorEntry next() {
            int pos = this.iter.nextInt();
            return new VectorEntry(SparseVector.this, pos, SparseVector.this.keys.getKey(pos), SparseVector.this.values[pos], true);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

