/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.vectors;

import it.unimi.dsi.fastutil.longs.AbstractLong2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Iterator;
import org.grouplens.lenskit.collections.CollectionUtils;
import org.grouplens.lenskit.vectors.SparseVector;
import org.grouplens.lenskit.vectors.VectorEntry;

class SparseVectorMap
extends AbstractLong2ObjectMap<Double> {
    final SparseVector vector;

    SparseVectorMap(SparseVector vec) {
        this.vector = vec;
    }

    SparseVector getVector() {
        return this.vector;
    }

    public ObjectSet<Long2ObjectMap.Entry<Double>> long2ObjectEntrySet() {
        return new EntrySetImpl();
    }

    public LongSet keySet() {
        return this.vector.keySet();
    }

    public ObjectCollection<Double> values() {
        return CollectionUtils.objectCollection(this.vector.values());
    }

    public Double get(long key) {
        if (this.vector.containsKey(key)) {
            return this.vector.get(key);
        }
        return (Double)this.defaultReturnValue();
    }

    public boolean containsKey(long key) {
        return this.vector.containsKey(key);
    }

    public int size() {
        return this.vector.size();
    }

    static class EntryShim
    implements Long2ObjectMap.Entry<Double> {
        VectorEntry entry;

        public EntryShim(VectorEntry e) {
            this.entry = e;
        }

        void setEntry(VectorEntry e) {
            this.entry = e;
        }

        public long getLongKey() {
            return this.entry.getKey();
        }

        public Long getKey() {
            return this.entry.getKey();
        }

        public Double getValue() {
            return this.entry.getValue();
        }

        public Double setValue(Double value) {
            throw new UnsupportedOperationException("setValue not supported");
        }
    }

    class FastEntryIterator
    extends AbstractObjectIterator<Long2ObjectMap.Entry<Double>> {
        Iterator<VectorEntry> delegate;
        EntryShim entry;

        FastEntryIterator() {
            this.delegate = SparseVectorMap.this.vector.fastIterator();
            this.entry = new EntryShim(null);
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Long2ObjectMap.Entry<Double> next() {
            VectorEntry e = this.delegate.next();
            this.entry.setEntry(e);
            return this.entry;
        }
    }

    class EntryIterator
    extends AbstractObjectIterator<Long2ObjectMap.Entry<Double>> {
        Iterator<VectorEntry> delegate;

        EntryIterator() {
            this.delegate = SparseVectorMap.this.vector.fastIterator();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Long2ObjectMap.Entry<Double> next() {
            VectorEntry e = this.delegate.next();
            return new AbstractLong2ObjectMap.BasicEntry(e.getKey(), (Object)e.getValue());
        }
    }

    class EntrySetImpl
    extends AbstractObjectSet<Long2ObjectMap.Entry<Double>>
    implements Long2ObjectMap.FastEntrySet<Double> {
        EntrySetImpl() {
        }

        public ObjectIterator<Long2ObjectMap.Entry<Double>> iterator() {
            return new EntryIterator();
        }

        public int size() {
            return SparseVectorMap.this.vector.size();
        }

        public ObjectIterator<Long2ObjectMap.Entry<Double>> fastIterator() {
            return new FastEntryIterator();
        }
    }
}

