/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.vectors;

import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.AbstractLong2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import org.grouplens.lenskit.collections.LongKeyDomain;
import org.grouplens.lenskit.vectors.MutableTypedSideChannel;

class TypedSideChannel<V>
extends AbstractLong2ObjectMap<V> {
    private static final long serialVersionUID = 1L;
    protected final LongKeyDomain keys;
    protected V[] values;
    protected boolean frozen = false;

    TypedSideChannel(LongKeyDomain ks) {
        this(ks, new Object[ks.domainSize()]);
        ks.setAllActive(false);
    }

    TypedSideChannel(LongKeyDomain ks, V[] vs) {
        this(ks, vs, null);
    }

    TypedSideChannel(LongKeyDomain ks, V[] vs, V def) {
        assert (vs.length >= ks.domainSize());
        this.keys = ks;
        this.values = vs;
        this.defRetValue = def;
    }

    public ObjectSet<Long2ObjectMap.Entry<V>> long2ObjectEntrySet() {
        return new EntrySetImpl();
    }

    public boolean containsValue(Object o) {
        if (o == null) {
            return false;
        }
        IntBidirectionalIterator iter = this.keys.activeIndexIterator(false);
        while (iter.hasNext()) {
            if (!o.equals(this.values[iter.nextInt()])) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(long key) {
        return this.keys.keyIsActive(key);
    }

    public V get(long key) {
        int idx = this.keys.getIndexIfActive(key);
        if (idx >= 0) {
            return this.values[idx];
        }
        return (V)this.defaultReturnValue();
    }

    public int size() {
        return this.keys.size();
    }

    public void defaultReturnValue(V obj) {
        throw new UnsupportedOperationException();
    }

    public MutableTypedSideChannel<V> mutableCopy() {
        return new MutableTypedSideChannel<Object>(this.keys.clone(), Arrays.copyOf(this.values, this.keys.domainSize()), this.defaultReturnValue());
    }

    public TypedSideChannel<V> immutable() {
        return this;
    }

    private class EntryImpl
    implements Long2ObjectMap.Entry<V> {
        private int index;

        private EntryImpl(int idx) {
            assert (idx < 0 || TypedSideChannel.this.keys.indexIsActive(idx));
            this.index = idx;
        }

        private void setIndex(int idx) {
            assert (TypedSideChannel.this.keys.indexIsActive(idx));
            this.index = idx;
        }

        public long getLongKey() {
            return TypedSideChannel.this.keys.getKey(this.index);
        }

        public Long getKey() {
            return this.getLongKey();
        }

        public V getValue() {
            return TypedSideChannel.this.values[this.index];
        }

        public V setValue(V value) {
            Object old = TypedSideChannel.this.values[this.index];
            TypedSideChannel.this.values[this.index] = value;
            return old;
        }
    }

    private class EntrySetImpl
    extends AbstractObjectSet<Long2ObjectMap.Entry<V>>
    implements Long2ObjectMap.FastEntrySet<V> {
        private EntrySetImpl() {
        }

        public ObjectIterator<Long2ObjectMap.Entry<V>> iterator() {
            return new AbstractObjectIterator<Long2ObjectMap.Entry<V>>(){
                IntIterator iter;
                {
                    this.iter = TypedSideChannel.this.keys.activeIndexIterator(false);
                }

                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                public Long2ObjectMap.Entry<V> next() {
                    int idx = this.iter.nextInt();
                    return new EntryImpl(idx);
                }
            };
        }

        public int size() {
            return Iterators.size(this.iterator());
        }

        public ObjectIterator<Long2ObjectMap.Entry<V>> fastIterator() {
            return new AbstractObjectIterator<Long2ObjectMap.Entry<V>>(){
                IntIterator iter;
                EntryImpl entry;
                {
                    this.iter = TypedSideChannel.this.keys.activeIndexIterator(false);
                    this.entry = new EntryImpl(-1);
                }

                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                public Long2ObjectMap.Entry<V> next() {
                    this.entry.setIndex(this.iter.nextInt());
                    return this.entry;
                }
            };
        }
    }
}

