/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.vectors;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import org.grouplens.lenskit.vectors.ImmutableVec;
import org.grouplens.lenskit.vectors.MutableVec;

public abstract class Vec
implements Serializable {
    private static final long serialVersionUID = 1L;
    final double[] data;

    Vec(double[] d) {
        this.data = d;
    }

    public final double get(int i) {
        Preconditions.checkElementIndex((int)i, (int)this.data.length);
        return this.data[i];
    }

    public final int size() {
        return this.data.length;
    }

    public double norm() {
        double ssq = 0.0;
        for (double v : this.data) {
            ssq += v * v;
        }
        return Math.sqrt(ssq);
    }

    public double sum() {
        double s = 0.0;
        for (double v : this.data) {
            s += v;
        }
        return s;
    }

    public double mean() {
        return this.sum() / (double)this.size();
    }

    public final double dot(Vec other) {
        int sz = this.data.length;
        Preconditions.checkArgument((sz == other.size() ? 1 : 0) != 0, (Object)"incompatible vector dimensions");
        double s = 0.0;
        for (int i = 0; i < sz; ++i) {
            s += this.data[i] * other.data[i];
        }
        return s;
    }

    public ImmutableVec immutable() {
        return ImmutableVec.create(this.data);
    }

    public MutableVec mutableCopy() {
        return MutableVec.wrap(Arrays.copyOf(this.data, this.data.length));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof Vec && Arrays.equals(this.data, ((Vec)o).data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

