/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.vectors;

import com.google.common.base.Function;
import javax.annotation.Nullable;
import org.grouplens.lenskit.vectors.SparseVector;

public final class VectorEntry
implements Cloneable {
    @Nullable
    private final SparseVector vector;
    private int index;
    private long key;
    private double value;
    private boolean isSet;

    VectorEntry(@Nullable SparseVector vec, int i, long k, double val, boolean set) {
        this.vector = vec;
        this.index = i;
        this.key = k;
        this.value = val;
        this.isSet = set;
    }

    public long getKey() {
        return this.key;
    }

    public double getValue() {
        return this.value;
    }

    int getIndex() {
        return this.index;
    }

    public boolean isSet() {
        return this.isSet;
    }

    void set(int i, long k, double v, boolean set) {
        this.index = i;
        this.key = k;
        this.value = v;
        this.isSet = set;
    }

    void setValue(double v) {
        this.value = v;
    }

    @Nullable
    public SparseVector getVector() {
        return this.vector;
    }

    public VectorEntry clone() {
        VectorEntry e;
        try {
            e = (VectorEntry)super.clone();
        }
        catch (CloneNotSupportedException exc) {
            throw new AssertionError((Object)exc);
        }
        return e;
    }

    public String toString() {
        return "VectorEntry: index=" + this.index + " key=" + this.key + " value=" + this.value + " isSet=" + this.isSet;
    }

    static Function<VectorEntry, VectorEntry> copyFunction() {
        return CopyFunction.INSTANCE;
    }

    private static enum CopyFunction implements Function<VectorEntry, VectorEntry>
    {
        INSTANCE;


        @Nullable
        public VectorEntry apply(@Nullable VectorEntry input) {
            if (input == null) {
                return null;
            }
            return input.clone();
        }
    }

    public static enum State {
        SET,
        UNSET,
        EITHER;

    }
}

