/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.vectors;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.grouplens.lenskit.collections.CollectionUtils;
import org.grouplens.lenskit.collections.IntPointer;
import org.grouplens.lenskit.scored.ScoredId;
import org.grouplens.lenskit.symbols.Symbol;
import org.grouplens.lenskit.symbols.TypedSymbol;
import org.grouplens.lenskit.vectors.MutableSparseVector;
import org.grouplens.lenskit.vectors.SparseVector;
import org.grouplens.lenskit.vectors.VectorEntry;

public final class Vectors {
    private static final Function<Pair<VectorEntry, VectorEntry>, ImmutablePair<VectorEntry, VectorEntry>> IMMUTABLE_PAIR_COPY = new Function<Pair<VectorEntry, VectorEntry>, ImmutablePair<VectorEntry, VectorEntry>>(){

        @Nullable
        public ImmutablePair<VectorEntry, VectorEntry> apply(@Nullable Pair<VectorEntry, VectorEntry> p) {
            VectorEntry right;
            if (p == null) {
                return null;
            }
            VectorEntry left = (VectorEntry)p.getLeft();
            if (left != null) {
                left = left.clone();
            }
            if ((right = (VectorEntry)p.getRight()) != null) {
                right = right.clone();
            }
            return ImmutablePair.of((Object)left, (Object)right);
        }
    };

    private Vectors() {
    }

    public static MutableSparseVector fromScoredIds(List<ScoredId> scores) {
        LongOpenHashSet ids = new LongOpenHashSet();
        for (ScoredId sid : CollectionUtils.fast(scores)) {
            ids.add(sid.getId());
        }
        MutableSparseVector vec = new MutableSparseVector((Collection<Long>)ids);
        for (ScoredId sid : CollectionUtils.fast(scores)) {
            long id = sid.getId();
            if (vec.containsKey(id)) continue;
            vec.set(id, sid.getScore());
            for (Symbol symbol : sid.getUnboxedChannelSymbols()) {
                vec.getOrAddChannelVector(symbol).set(id, sid.getUnboxedChannelValue(symbol));
            }
            for (TypedSymbol typedSymbol : sid.getChannelSymbols()) {
                if (typedSymbol.getType().equals(Double.class)) continue;
                vec.getOrAddChannel(typedSymbol).put(id, sid.getChannelValue(typedSymbol));
            }
        }
        return vec;
    }

    public static Iterable<ImmutablePair<VectorEntry, VectorEntry>> intersect(final SparseVector v1, final SparseVector v2) {
        return new Iterable<ImmutablePair<VectorEntry, VectorEntry>>(){

            @Override
            public Iterator<ImmutablePair<VectorEntry, VectorEntry>> iterator() {
                return Iterators.transform((Iterator)new FastIntersectIterImpl(v1, v2), (Function)IMMUTABLE_PAIR_COPY);
            }
        };
    }

    public static Iterable<Pair<VectorEntry, VectorEntry>> fastIntersect(final SparseVector v1, final SparseVector v2) {
        return new Iterable<Pair<VectorEntry, VectorEntry>>(){

            @Override
            public Iterator<Pair<VectorEntry, VectorEntry>> iterator() {
                return new FastIntersectIterImpl(v1, v2);
            }
        };
    }

    private static class FastIntersectIterImpl
    implements Iterator<Pair<VectorEntry, VectorEntry>> {
        private boolean atNext = false;
        private final SparseVector vec1;
        private final SparseVector vec2;
        private IntPointer p1;
        private IntPointer p2;
        private VectorEntry leftEnt;
        private VectorEntry rightEnt;
        private MutablePair<VectorEntry, VectorEntry> pair;

        public FastIntersectIterImpl(SparseVector v1, SparseVector v2) {
            this.vec1 = v1;
            this.vec2 = v2;
            this.p1 = v1.keys.activeIndexPointer(false);
            this.p2 = v2.keys.activeIndexPointer(false);
            this.leftEnt = new VectorEntry(v1, -1, 0L, 0.0, false);
            this.rightEnt = new VectorEntry(v2, -1, 0L, 0.0, false);
            this.pair = MutablePair.of((Object)this.leftEnt, (Object)this.rightEnt);
        }

        @Override
        public boolean hasNext() {
            if (!this.atNext) {
                while (!this.p1.isAtEnd() && !this.p2.isAtEnd()) {
                    long key2;
                    long key1 = this.vec1.keys.getKey(this.p1.getInt());
                    if (key1 == (key2 = this.vec2.keys.getKey(this.p2.getInt()))) {
                        this.atNext = true;
                        break;
                    }
                    if (key1 < key2) {
                        this.p1.advance();
                        continue;
                    }
                    this.p2.advance();
                }
            }
            return this.atNext;
        }

        @Override
        public Pair<VectorEntry, VectorEntry> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int i1 = this.p1.getInt();
            int i2 = this.p2.getInt();
            assert (this.vec1.keys.getKey(i1) == this.vec2.keys.getKey(i2));
            this.leftEnt.set(i1, this.vec1.keys.getKey(i1), this.vec1.values[i1], true);
            this.p1.advance();
            this.rightEnt.set(i2, this.vec2.keys.getKey(i2), this.vec2.values[i2], true);
            this.p2.advance();
            this.atNext = false;
            return this.pair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

