/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AbstractFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.grouplens.lenskit.eval.EvalConfig;
import org.grouplens.lenskit.eval.EvalProject;
import org.grouplens.lenskit.eval.EvalTask;
import org.grouplens.lenskit.eval.TaskExecutionException;

public abstract class AbstractTask<T>
extends AbstractFuture<T>
implements EvalTask<T> {
    @Nullable
    private String name;
    private EvalProject project;

    protected AbstractTask() {
        this(null);
    }

    protected AbstractTask(@Nullable String name) {
        this.name = name;
    }

    public AbstractTask<T> setProject(@Nonnull EvalProject ep) {
        Preconditions.checkNotNull((Object)ep, (Object)"project cannot be null");
        this.project = ep;
        return this;
    }

    @Nonnull
    public EvalProject getProject() {
        if (this.project == null) {
            throw new IllegalStateException("no project configured");
        }
        return this.project;
    }

    @Nonnull
    @Deprecated
    public EvalConfig getEvalConfig() {
        return this.getProject().getConfig();
    }

    public AbstractTask<T> setName(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    public void execute() throws TaskExecutionException {
        T result;
        try {
            result = this.perform();
        }
        catch (Exception ex) {
            this.setException(ex);
            Throwables.propagateIfPossible((Throwable)ex, TaskExecutionException.class);
            throw new RuntimeException("unexpected exception", ex);
        }
        this.set(result);
    }

    protected abstract T perform() throws TaskExecutionException;
}

