/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval;

import java.util.Collections;
import java.util.concurrent.Future;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.grouplens.lenskit.eval.EvalTask;
import org.grouplens.lenskit.eval.TaskExecutionException;

public class EvalAntTask
extends Task {
    private final EvalTask<?> evalTask;
    private final Iterable<? extends Future<?>> dependencies;

    public EvalAntTask(EvalTask<?> task) {
        this(task, Collections.emptyList());
    }

    public EvalAntTask(EvalTask<?> task, Iterable<? extends Future<?>> deps) {
        this.evalTask = task;
        this.dependencies = deps;
    }

    public EvalTask<?> getEvalTask() {
        return this.evalTask;
    }

    public void execute() throws BuildException {
        for (Future<?> dep : this.dependencies) {
            if (dep.isDone()) continue;
            throw new BuildException("dependency not yet satisfied");
        }
        try {
            this.evalTask.execute();
        }
        catch (TaskExecutionException e) {
            throw new BuildException("error running eval task", (Throwable)e);
        }
    }

    public String toString() {
        return this.evalTask.toString();
    }
}

