/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.eval;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;

public class EvalConfig {
    public static final String FORCE_PROPERTY = "lenskit.eval.force";
    public static final String SKIP_PROPERTY = "lenskit.eval.skip";
    public static final String EVAL_SCRIPT_PROPERTY = "lenskit.eval.script";
    public static final String EVAL_SCRIPTFILES_PROPERTY = "lenskit.eval.scripts";
    public static final String SCRIPT_DIR_PROPERTY = "lenskit.eval.scriptDir";
    public static final String DATA_DIR_PROPERTY = "lenskit.eval.dataDir";
    public static final String ANALYSIS_DIR_PROPERTY = "lenskit.eval.analysisDir";
    public static final String THREAD_COUNT_PROPERTY = "lenskit.eval.threadCount";
    private final Map<String, String> properties;

    public EvalConfig(@Nonnull Map props) {
        this.properties = props;
    }

    public String get(String key, @Nullable String defaultValue) {
        String val = this.properties.get(key);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public boolean force() {
        return BooleanUtils.toBoolean((String)this.get(FORCE_PROPERTY));
    }

    public String getScript() {
        return this.get(EVAL_SCRIPT_PROPERTY, "eval.groovy");
    }

    public String getDataDir() {
        return this.get(DATA_DIR_PROPERTY, ".");
    }

    public String getScriptDir() {
        return this.get(SCRIPT_DIR_PROPERTY, ".");
    }

    public String getAnalysisDir() {
        return this.get(ANALYSIS_DIR_PROPERTY, ".");
    }

    public int getThreadCount() {
        int count = Integer.parseInt(this.get(THREAD_COUNT_PROPERTY, "1"));
        if (count == 0) {
            return Runtime.getRuntime().availableProcessors();
        }
        return count;
    }
}

